% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractors.R
\name{fitted.GPPM}
\alias{fitted.GPPM}
\title{Person-specific mean vectors and covariance matrices}
\usage{
\method{fitted}{GPPM}(object, ...)
}
\arguments{
\item{object}{object of class GPPM. Must be fitted, that is, a result from \code{\link{fit.GPPM}}.}

\item{...}{additional arguments (currently not used).}
}
\value{
Returns a list structure with mean and covariances matrices. See example.
}
\description{
A fitted GPPM implies a mean vector and a covariance matrix for each person. These are returned by this function.
}
\examples{
\donttest{
data("demoLGCM")
lgcm <- gppm(
  "muI+muS*t", "varI+covIS*(t+t#)+varS*t*t#+(t==t#)*sigma",
  demoLGCM, "ID", "y"
)
lgcmFit <- fit(lgcm)
meansCovs <- fitted(lgcmFit)

person1Mean <- meansCovs$mean[[1]]
person1Cov <- meansCovs$cov[[1]]
person1ID <- meansCovs$ID[[1]]
}
}
\seealso{
Other functions to extract from a GPPM: 
\code{\link{SE}()},
\code{\link{coef.GPPM}()},
\code{\link{confint.GPPM}()},
\code{\link{covFun}()},
\code{\link{getData}()},
\code{\link{getIntern}()},
\code{\link{logLik.GPPM}()},
\code{\link{maxNObs}()},
\code{\link{meanFun}()},
\code{\link{nObs}()},
\code{\link{nPars}()},
\code{\link{nPers}()},
\code{\link{nPreds}()},
\code{\link{parEsts}()},
\code{\link{pars}()},
\code{\link{preds}()},
\code{\link{vcov.GPPM}()}
}
\concept{functions to extract from a GPPM}
