% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gprofiler2.R
\name{gostplot}
\alias{gostplot}
\title{Manhattan plot of functional enrichment results.}
\usage{
gostplot(gostres, capped = TRUE, interactive = TRUE, pal = c(`GO:MF`
  = "#dc3912", `GO:BP` = "#ff9900", `GO:CC` = "#109618", KEGG = "#dd4477",
  REAC = "#3366cc", WP = "#0099c6", TF = "#5574a6", MIRNA = "#22aa99", HPA
  = "#6633cc", CORUM = "#66aa00", HP = "#990099"))
}
\arguments{
\item{gostres}{named list from gost() function (with names 'result' and 'meta')}

\item{capped}{whether the -log10(p-values) would be capped if >= 16, just as in the web options.}

\item{interactive}{if enabled, returns interactive plot using 'plotly'. If disabled, static 'ggplot()' object is returned.}

\item{pal}{values mapped to relevant colors for data sources.}
}
\value{
The output is either a plotly object (if interactive = TRUE) or a ggplot object (if interactive = FALSE).
}
\description{
This function creates a Manhattan plot out of the results from gprofiler2::gost().
The plot is very similar to the one shown in the g:GOSt web tool.
}
\examples{
 gostres <- gost(c("Klf4", "Pax5", "Sox2", "Nanog"), organism = "mmusculus")
 gostplot(gostres)
}
\author{
Liis Kolberg <liis.kolberg@ut.ee>
}
