% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reorder_mat.R
\name{reorder_mat}
\alias{reorder_mat}
\title{Reorder the rows and columns of a symmetric matrix}
\usage{
reorder_mat(mat, order)
}
\arguments{
\item{mat}{An object of class \code{matrix}}

\item{order}{A character vector with the rows and columns names of the matrix
in the order in which they will be ordered by the function. All its elements
must be rows and columns names of the matrix \code{mat}.}
}
\value{
A reordered symmetric matrix
}
\description{
The function reorders the rows and columns of a symmetric
matrix according to a specified order.
}
\details{
The matrix \code{mat} must be symmetric and have rows and columns
names. Its values are not modified.
}
\examples{
mat <- matrix(rnorm(36), 6)
mat[lower.tri(mat)] <- t(mat)[lower.tri(mat)]
row.names(mat) <- colnames(mat) <- c("A", "C", "E", "B", "D", "F")
order <- c("A", "B", "C", "D", "E", "F")
mat <- reorder_mat(mat = mat, order = order)
}
\author{
P. Savary
}
