% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatter_dist.R
\name{scatter_dist}
\alias{scatter_dist}
\title{Plot scatterplots of genetic distance vs landscape distance}
\usage{
scatter_dist(
  mat_gd,
  mat_ld,
  method = "loess",
  thr_gd = NULL,
  thr_ld = NULL,
  se = TRUE,
  smooth_col = "black",
  pts_col = "#999999"
)
}
\arguments{
\item{mat_gd}{A symmetric \code{matrix} with pairwise genetic distances
between populations or sample sites.}

\item{mat_ld}{A symmetric \code{matrix} with pairwise landscape distances
between populations or sample sites. These distances can be
Euclidean distances, cost-distances or resistance distances, among others.}

\item{method}{A character string indicating the smoothing method
used to fit a line on the scatterplot. Possible values are the same as
with function 'geom_smooth()' from \pkg{ggplot2} : 'lm', 'glm', 'gam',
'loess' (default).}

\item{thr_gd}{(optional) A numeric value used to remove values from the
data before to plot. All genetic distances values above \code{thr_gd}
are removed from the data.}

\item{thr_ld}{(optional) A numeric value used to remove values from the
data before to plot. All landscape distances values above \code{thr_ld}
are removed from the data.}

\item{se}{Logical (optional, default = TRUE) indicating whether the
confidence interval around the smooth line is displayed.}

\item{smooth_col}{(optional) A character string indicating the color
used to plot the smoothing line (default: "blue"). It must be a hexadecimal
color code or a color used by default in R.}

\item{pts_col}{(optional) Character string indicating the color
used to plot the points (default: "#999999"). It must be a hexadecimal color
code or a color used by default in R.}
}
\value{
A ggplot2 object to plot
}
\description{
The function enables to plot scatterplots to visualize the
relationship between genetic distance (or differentiation) and landscape
distance (Euclidean distance, cost-distance, etc.)between populations or
sample sites.
}
\details{
IDs in \code{mat_gd} and \code{mat_ld} must be the same and refer
to the same sampling sites or populations, and both matrices must be ordered
in the same way.
Matrix of genetic distance \code{mat_gd} can be computed using
\code{\link{mat_gen_dist}}.
Matrix of landscape distance \code{mat_ld} can be computed using
\code{\link{mat_geo_dist}} when the landscape distance needed is a
Euclidean geographical distance.
}
\examples{
data(data_tuto)
mat_dps <- data_tuto[[1]]
mat_dist <- suppressWarnings(mat_geo_dist(data = pts_pop_simul,
      ID = "ID",
      x = "x",
      y = "y"))
mat_dist <- mat_dist[order(as.character(row.names(mat_dist))),
                      order(as.character(colnames(mat_dist)))]
scatterplot_ex <- scatter_dist(mat_gd = mat_dps,
                              mat_ld = mat_dist)
}
\author{
P. Savary
}
