% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_checks.R
\name{checkGamma}
\alias{checkGamma}
\alias{checkSigmaTheta}
\alias{checkTheta}
\alias{checkSigma}
\alias{checkMatrix}
\alias{is_valid_Gamma}
\alias{is_valid_Theta}
\alias{is_valid_Sigma}
\title{HR parameter matrix checks}
\usage{
checkGamma(Gamma, alert = NULL, tol = get_small_tol(), returnBoolean = FALSE)

checkSigmaTheta(
  M,
  k,
  full,
  matrixName = "Sigma",
  tol = get_small_tol(),
  alert = NULL,
  returnBoolean = FALSE
)

checkTheta(
  Theta,
  k = NULL,
  full = FALSE,
  tol = get_small_tol(),
  alert = NULL,
  returnBoolean = FALSE
)

checkSigma(
  Sigma,
  k = NULL,
  full = FALSE,
  tol = get_small_tol(),
  alert = NULL,
  returnBoolean = FALSE
)

checkMatrix(
  M,
  name = c("Gamma", "Sigma", "Theta")[1],
  k = NULL,
  full = FALSE,
  tol = get_small_tol(),
  alert = NULL,
  returnBoolean = FALSE
)

is_valid_Gamma(M, tol = get_small_tol())

is_valid_Theta(Theta, k = NULL, full = FALSE, tol = get_small_tol())

is_valid_Sigma(Sigma, k = NULL, full = FALSE, tol = get_small_tol())
}
\arguments{
\item{Gamma}{Numeric \dxd variogram matrix.}

\item{alert}{Passed to \code{get_alert_function}: \code{NULL} or \code{TRUE} to read the option value,
\code{FALSE} to return a dummy function, or a function that takes an arbitrary number of strings as arguments (e.g. \code{stop()}).}

\item{tol}{Numeric scalar. Values below this are considered as zero,
when zeros are required (e.g. row-sums).}

\item{returnBoolean}{Logical scalar, set to \code{TRUE} to return a boolean instead of the (adjusted) input.}

\item{M}{Numeric matrix, \eGamma, \eSigma, or \eTheta.}

\item{k}{\code{NULL} if the input/output matrix is \eSigma/\eTheta.
Else, an integer between 1 and d indicating the value of k in \eSigmaK, \eThetaK.}

\item{full}{Logical. If \code{TRUE} and \code{!is.null(k)},
the input/output matrix is a \dxd matrix with the kth row filled with zeros.}

\item{matrixName}{Name of the matrix to be used in alerts/error messages.}

\item{Theta}{Numeric \dxd or \d1xd1 precision matrix.}

\item{Sigma}{Numeric \dxd or \d1xd1 covariance matrix.}

\item{name}{Name of the input matrix, indicating which other function to call.}
}
\value{
For \verb{check*}, the input matrix, passed through \code{\link{ensure_matrix_symmetry_and_truncate_zeros}}.

For \verb{is_valid_*}, a boolean indicating whether the input is a valid parameter matrix.
}
\description{
Checks whether the matrix given is a valid Huesler-Reiss parameter matrix
in the role of \eGamma, \eTheta, or \eSigma, respectively.
}
\details{
The function \verb{is_valid_*} are a wrapper around \verb{check*}, with arguments
\code{alert=FALSE} and \code{returnBoolean=TRUE}.
}
\seealso{
Other input validation functions:
\code{\link{check_graph}()},
\code{\link{check_partial_matrix_and_graph}()},
\code{\link{ensure_matrix_symmetry}()}
}
\concept{inputChecks}
