% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddm.R
\name{ddm}
\alias{ddm}
\title{Double Demeaning (DDM)}
\usage{
ddm(dependent_variable, distance, additional_regressors = NULL,
  code_origin, code_destination, robust = FALSE, data, ...)
}
\arguments{
\item{dependent_variable}{(Type: character) name of the dependent variable. This dependent variable is 
divided by the product of unilateral incomes such (i.e. \code{income_origin} and \code{income_destination}) 
and logged afterwards.}

\item{distance}{(Type: character) name of the distance variable that should be taken as the key independent variable 
in the estimation. The distance is logged automatically when the function is executed.}

\item{additional_regressors}{(Type: character) names of the additional regressors to include in the model (e.g. a dummy
variable to indicate contiguity). Unilateral metric variables such as GDP should be inserted via the arguments 
\code{income_origin} and \code{income_destination}. As country specific effects are subdued due to demeaning, no further unilateral variables apart from incomes can be added.

Write this argument as \code{c(contiguity, common currency, ...)}. By default this is set to \code{NULL}.}

\item{code_origin}{(Type: character) country of origin variable (e.g. ISO-3 country codes). The variables are grouped 
using this parameter.}

\item{code_destination}{(Type: character) country of destination variable (e.g. country ISO-3 codes). The variables are 
grouped using this parameter.}

\item{robust}{(Type: logical) whether robust fitting should be used. By default this is set to \code{FALSE}.}

\item{data}{(Type: data.frame) the dataset to be used.}

\item{...}{Additional arguments to be passed to the function.}
}
\value{
The function returns the summary of the estimated gravity model as an
\code{\link[stats]{lm}}-object.
}
\description{
\code{ddm} estimates gravity models via double demeaning the
left hand side and right hand side of the gravity equation.
}
\details{
\code{ddm} is an estimation method for gravity models presented
in \insertCite{Head2014;textual}{gravity}.

Country specific effects are subdued due double demeaning. Hence, unilateral income
proxies such as GDP cannot be considered as exogenous variables.

Unilateral effect drop out due to double demeaning and therefore cannot be estimated.

\code{ddm} is designed to be consistent with the Stata code provided at
\href{https://sites.google.com/site/hiegravity/}{Gravity Equations: Workhorse, Toolkit, and Cookbook}
when choosing robust estimation.

As, to our knowledge at the moment, there is no explicit literature covering
the estimation of a gravity equation by \code{ddm} using panel data,
we do not recommend to apply this method in this case.
}
\examples{
# Example for CRAN checks:
# Executable in < 5 sec
library(dplyr)
data("gravity_no_zeros")

# Choose 5 countries for testing
countries_chosen <- c("AUS", "CHN", "GBR", "BRA", "CAN")
grav_small <- filter(gravity_no_zeros, iso_o \%in\% countries_chosen)

fit <- ddm(
  dependent_variable = "flow",
  distance = "distw",
  additional_regressors = c("rta", "comcur", "contig"),
  code_origin = "iso_o",
  code_destination = "iso_d",
  robust = FALSE,
  data = grav_small
)

}
\references{
For more information on gravity models, theoretical foundations and
estimation methods in general see

\insertRef{Anderson1979}{gravity}

\insertRef{Anderson2001}{gravity}

\insertRef{Anderson2010}{gravity}

\insertRef{Baier2009}{gravity}

\insertRef{Baier2010}{gravity}

\insertRef{Feenstra2002}{gravity}

\insertRef{Head2010}{gravity}

\insertRef{Head2014}{gravity}

\insertRef{Santos2006}{gravity}

and the citations therein.

See \href{https://sites.google.com/site/hiegravity/}{Gravity Equations: Workhorse, Toolkit, and Cookbook} for gravity datasets and Stata code for estimating gravity models.

For estimating gravity equations using panel data see

\insertRef{Egger2003}{gravity}

\insertRef{Gomez-Herrera2013}{gravity}

and the references therein.
}
\seealso{
\code{\link[stats]{lm}}, \code{\link[lmtest]{coeftest}},
\code{\link[sandwich]{vcovHC}}
}
