% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze_green_accessibility.R
\name{analyze_green_accessibility}
\alias{analyze_green_accessibility}
\title{Analyze Green Space Accessibility Using Street Network}
\usage{
analyze_green_accessibility(
  network_data,
  green_areas,
  mode = "all",
  grid_size = 500,
  population_raster = NULL
)
}
\arguments{
\item{network_data}{\code{sf} object or \code{osmdata} object with \code{osm_lines} representing street network.}

\item{green_areas}{\code{sf} object or \code{osmdata} object with \code{osm_polygons} representing green areas.}

\item{mode}{Character. One of \code{"walking"}, \code{"cycling"}, \code{"driving"}, or \code{"all"}. Defaults to \code{"all"}.}

\item{grid_size}{Numeric. Grid cell size in meters. Default is 500.}

\item{population_raster}{Optional. A \code{terra::SpatRaster} object with gridded population data (e.g., GHSL).}
}
\value{
A named list by mode. Each element contains:
\describe{
\item{grid}{An \code{sf} grid with per-cell accessibility and population metrics.}
\item{stats}{Data frame with spatial and population-weighted accessibility metrics.}
\item{summary}{Named list of summary statistics for plotting or reporting.}
}
}
\description{
Computes green space accessibility using network distances from grid centroids to the nearest green area.
Supports travel modes like walking, cycling, and driving by filtering appropriate road types and assigning travel speed.
Optionally supports population-weighted metrics if population raster data is provided (e.g., GHSL).
}
\examples{
\dontrun{
# Example 1: Green accessibility using OSM network and green polygons, no population
data <- get_osm_data("City of London, United Kingdom")
result_no_pop <- analyze_green_accessibility(
  network_data = data$highways$osm_lines,
  green_areas = data$green_areas$osm_polygons,
  mode = "walking",
  grid_size = 300
)
print(result_no_pop$stats)

# Example 2: With GHSL population raster (if you have the raster file)
library(terra)
ghsl_path <- "GHS_POP_E2025_GLOBE_R2023A_54009_100_V1_0_R4_C19.tif"  # Update path as needed
pop_raster_raw <- terra::rast(ghsl_path)

# Optionally, crop raster to the city area (recommended for speed)
# aoi <- sf::st_transform(st_as_sfc(st_bbox(data$highways$osm_lines)), terra::crs(pop_raster_raw))
# pop_raster_raw <- terra::crop(pop_raster_raw, aoi)

result_with_pop <- analyze_green_accessibility(
  network_data = data$highways$osm_lines,
  green_areas = data$green_areas$osm_polygons,
  mode = "walking",
  grid_size = 300,
  population_raster = pop_raster_raw
)
print(result_with_pop$stats)
}
}
