% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Misc.r
\name{putFig}
\alias{putFig}
\title{Put Figure}
\usage{
putFig(panel, name, caption = NULL, longcaption = NULL,
  tcaption = caption, tlongcaption = NULL, poptable = NULL,
  popfull = FALSE, sidecap = FALSE, outtable = FALSE, append = TRUE)
}
\arguments{
\item{panel}{character. Panel name.}

\item{name}{character. Name for figure.}

\item{caption}{character. Short caption for figure.}

\item{longcaption}{character. Long caption for figure.}

\item{tcaption}{character.  Short caption for supporting table.}

\item{tlongcaption}{character.  Long caption for supporting table.}

\item{poptable}{an optional character string containing LaTeX code that will be used as a pop-up tool tip for the figure (typically a tabular).  Set to \code{NULL} to suppress supplemental tables that back up figures.}

\item{popfull}{set to \code{TRUE} to make the pop-up be full-page}

\item{sidecap}{set to \code{TRUE} (only applies if \code{greportOption(figenv="SCfigure")}) to assume the figure is narrow and to use side captions}

\item{outtable}{set to \code{TRUE} to only have the caption and hyperlink to graphics in a LaTeX table environment and to leave the tabulars to free-standing LaTeX markup.  This is useful when the table is long, to prevent hyperlinking from making the table run outside the visable area.  Instead of the hyperlink area being the whole table, it will be the caption.  A \code{clearpage} is issued after the tabular.}

\item{append}{logical. If \sQuote{TRUE} output will be appended instead of overwritten.}
}
\description{
Included a generated figure within LaTex document.  \code{tcaption} and \code{tlongcaption} only apply if \code{setgreportOption(tablelink="hyperref")}.
}

