% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AutomaticDemandIdentifier.R
\name{aid}
\alias{aid}
\alias{aidCat}
\title{Automatic Identification of Demand}
\usage{
aid(y, ic = c("AICc", "AIC", "BICc", "BIC"), level = 0.99,
  loss = "likelihood", ...)

aidCat(data, ...)
}
\arguments{
\item{y}{The vector of the data.}

\item{ic}{Information criterion to use.}

\item{level}{The confidence level used in stockouts identification.}

\item{loss}{The type of loss function to use in model estimation. See
\link[greybox]{alm} for possible options.}

\item{...}{Other parameters passed to the \code{alm()} function. In case of the
\code{aidCat()} function, the \code{aid()} parameters can be passed here.}

\item{data}{The dataframe or a matrix to which the aid function should be applied}
}
\value{
\code{aid()} returns an object of class "aid", which contains:
\itemize{
\item y - The original data;
\item models - All fitted models;
\item ICs - Values of information criteria;
\item type - The type of the identified demand;
\item stockouts - List with start and end ids of potential stockouts;
\item new - Binary showing whether the data start with the abnormal number of zeroes.
Must be a new product then;
\item obsolete - Binary showing whether the data ends with the abnormal number of zeroes.
Must be product that was discontinued (obsolete).
}

\code{aidCat()} returns an object of class "aidCat", which contains:
\itemize{
\item categories - the vector with the names of categories for each time series;
\item types - the vector with the count of series in each category;
\item anomalies - the vector that contains counts of cases where product was flagged
as new, obsolete and having stockouts.
}
}
\description{
The function applies several models on the provided time series and identifies what
type of demand it is based on an information criterion.
}
\details{
In the first step, function creates inter-demand intervals and fits a model with LOWESS
of it assuming Geometric distribution. The outliers from this model are treated as
potential stock outs.

In the second step, the function creates explanatory variables based on LOWESS of the
original data, then applies Normal, Normal + Bernoulli models and selects the one that
has the lowest IC. Based on that, it decides what type of demand the data corresponds
to: regular or intermittent. Finally, if the data is count, the function will identify
that.
}
\examples{
# Data from Poisson distribution
y <- rpois(120, 0.7)
aid(y)

xreg <- cbind(x1=rpois(100,1), x2=rpois(100,2),
              x3=rpois(100,5), x4=rnorm(100,10,2))
plot(aidCat(xreg))
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.com}
}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{ts}
