% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structures.R
\name{add_structure}
\alias{add_structure}
\title{Add a Structure}
\usage{
add_structure(grob_object, structure, value)
}
\arguments{
\item{grob_object}{The R6 object initialized by one of:
\itemize{

\item \code{\link{grob_matrix}}
\item \code{\link{grob_image}}
\item \code{\link{grob_text}}

}}

\item{structure}{The structure the user wishes to add.}

\item{value}{If \code{grob_object} is outputted by \code{\link{grob_matrix}},
then a single value, or a vector of values corresponding to each column of 
the initial object passed through \code{\link{grob_matrix}}, the user wants to apply to the 
grob matrix object. 

Otherwise, a single value to apply to the \code{structure}.}
}
\value{
The initial R6 object of the grob object class with its structure properties altered.
}
\description{
Add a structure to a grob matrix / image / text object.
}
\details{
Accepted structures:

\describe{

\item{Matrix / Text}{

\itemize{

\item \code{column_widths_p}
\item \code{n_lines}
\item \code{padding_p}

}
}

\item{Image}{
\itemize{

\item \code{aspect_ratio_multiplier}
\item \code{maintain_aspect_ratio}

}
}

}

To see descriptions of the structures above, see the documentation of \code{\link{ga_list}}.
}
\examples{

df = data.frame(x = c(5, 14, 6, 10), y = c(3, 30, 17, 7))
df \%>\%
  grob_matrix() \%>\% 
  add_structure(structure = 'column_widths_p', value = c(1, 4)) \%>\%
  view_grob()
  
gg = ggplot2::ggplot(data = df, mapping = ggplot2::aes(x = x, y = y)) +
  ggplot2::geom_line(color = 'red')
  
gg \%>\%
  grob_image() \%>\% 
  view_grob()
  
}
