% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trtplot.R
\name{trtplot}
\alias{trtplot}
\title{Plot comparison of Mean Effects for Any Two Treatments}
\usage{
trtplot(run.objects, run.models, trt.labs, time.points, y.label = NULL,
  time.labels = NULL, n.thin = 10)
}
\arguments{
\item{run.objects}{A list object where each entry is either a \code{dpgrow}, \code{dgrowmm} or \code{dpgrowmult} object
returned from a model run.  The list length is equal to the number of models on which a treatment comparison is desired.}

\item{run.models}{A character vector supplying the names of models to compare of the same length as the number of elements in \code{run.objects}.}

\item{trt.labs}{A vector of exactly 2-elements that contains the labels (used in modeling) for the two treatments desired to compare.}

\item{time.points}{A numeric vector of data time points on which to compare the fixed effects treatment means.}

\item{y.label}{An optional character scalar for label for the y axis.}

\item{time.labels}{An optional character vector of labels for \code{time.points} to use in plotting.}

\item{n.thin}{Gap between successive MCMC sampling iterations on fixed effects parameters to use for generating distribution for each treatment-time.
Defaults to \code{n.thin = 10}.  Higher values produces faster plot generation.}
}
\value{
A list object containing quantile summaries for all sampled model parameters.
    \item{dat.trt}{A \code{data.frame} object used to generate the fixed effects mean comparison for two chosen treatments.
		Fields are titled, \code{c("Mu_diff","models","time")}.}
    \item{p.trt}{A \code{ggplot2} object of box plots split by time point.}
}
\description{
Produces a set of box plots of the posterior distributions of the fixed effects mean difference between any 2 chosen treatments
across a chosen subset models (priors) at each of a selection of time points.  Each box plot spans the 95% credible interval.
}
\author{
Terrance Savitsky \email{tds151@gmail.com}
}
\seealso{
\code{\link{dpgrowmm}}, \code{\link{dpgrow}}, \code{\link{dpgrowmult}}
}

