% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{splitinput}
\alias{splitinput}
\title{Split input data into multiple files}
\usage{
splitinput(
  df,
  fname = deparse(substitute(df)),
  fdir = NA,
  min_nrow = 10000,
  keepcol = "subjid"
)
}
\arguments{
\item{df}{data frame to split}

\item{fname}{new name for each of the split files to start with}

\item{fdir}{directory to put each of the split files (use "." for  working directory). Must be changed from default (NA), which will trigger error.}

\item{min_nrow}{minimum number of rows for each split file (default 10000)}

\item{keepcol}{the column name (default "subjid") to use to keep records with the same values together in the same single split file}
}
\value{
the count number referring to the last split file written
}
\description{
\code{splitinput} Splits input based on keepcol specified, yielding csv files each with at least the mininum
number of rows that are written and saved separately (except for the last split file written, which may be
smaller). Allows splitting input data while ensuring all records for each individual subject will stay together
in one file. Pads split filenames with zeros out to five digits for consistency, assuming < 100,000 file count
result.
}
\examples{
\donttest{
# Run on given data
df <- as.data.frame(syngrowth)

# Run with all defaults (specifying directory)
splitinput(df, fdir = tempdir())

# Specifying the name, directory and minimum row size
splitinput(df, fname = "syngrowth", fdir = tempdir(), min_nrow = 5000)

# Specifying a different subject ID column
colnames(df)[colnames(df) == "subjid"] <- "sub_id"
splitinput(df, fdir = tempdir(), keepcol = "sub_id")
}
}
