% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\docType{methods}
\name{predict,growthrates_fit-method}
\alias{predict,growthrates_fit-method}
\alias{predict,smooth.spline_fit-method}
\alias{predict,nonlinear_fit-method}
\alias{predict,multiple_fits-method}
\title{Model Predictions for \pkg{growthrates} Fits}
\usage{
\S4method{predict}{growthrates_fit}(object, ...)

\S4method{predict}{smooth.spline_fit}(object, ...)

\S4method{predict}{nonlinear_fit}(object, newdata, ...)

\S4method{predict}{multiple_fits}(object, ...)
}
\arguments{
\item{object}{name of a 'growthrates' object for which prediction is desired.}

\item{\dots}{additional arguments affecting the predictions produced.}

\item{newdata}{an optional data frame with column 'time' for new time steps with
which to predict. This argument is currently only available for parametric fits.}
}
\description{
Class-specific methods of package \pkg{growthrates} to make predictions.
}
\details{
The implementation of the predict methods is still experimental and not yet complete.
}
\examples{

data(bactgrowth)
splitted.data <- multisplit(bactgrowth, c("strain", "conc", "replicate"))

## get table from single experiment
dat <- splitted.data[[10]]

fit1 <- fit_spline(dat$time, dat$value, spar=0.5)
coef(fit1)
summary(fit1)

## derive start parameters from spline fit
p <- c(coef(fit1), K = max(dat$value))
fit2 <- fit_growthmodel(grow_logistic, p=p, time=dat$time, y=dat$value, transform="log")
coef(fit2)
rsquared(fit2)

predict(fit2)


}
\seealso{
\code{\link{methods}}, \code{\link{predict.smooth.spline}},
  \code{\link{predict.lm}}, \code{\link{predict.nls}}
}
