% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ahr.R
\name{ahr}
\alias{ahr}
\title{Average hazard ratio under non-proportional hazards (test version)}
\usage{
ahr(
  enroll_rate = define_enroll_rate(duration = c(2, 2, 10), rate = c(3, 6, 9)),
  fail_rate = define_fail_rate(duration = c(3, 100), fail_rate = log(2)/c(9, 18), hr =
    c(0.9, 0.6), dropout_rate = 0.001),
  total_duration = 30,
  ratio = 1
)
}
\arguments{
\item{enroll_rate}{An \code{enroll_rate} data frame with or without stratum
created by \code{\link[=define_enroll_rate]{define_enroll_rate()}}.}

\item{fail_rate}{A \code{fail_rate} data frame with or without stratum
created by \code{\link[=define_fail_rate]{define_fail_rate()}}.}

\item{total_duration}{Total follow-up from start of enrollment to data
cutoff; this can be a single value or a vector of positive numbers.}

\item{ratio}{Ratio of experimental to control randomization.}
}
\value{
A tibble with \code{time} (from \code{total_duration}),
\code{ahr} (average hazard ratio), \code{event} (expected number of events),
\code{info} (information under given scenarios), \code{and} info0
(information under related null hypothesis) for each value of
\code{total_duration} input.
}
\description{
Provides a geometric average hazard ratio under
various non-proportional hazards assumptions for either single or multiple strata studies.
The piecewise exponential distribution allows a simple method to specify a distribution
and enrollment pattern where the enrollment, failure and dropout rates changes over time.
}
\section{Specification}{

\if{latex}{
 \itemize{
   \item Validate if input enrollment rate contains stratum column.
   \item Validate if input enrollment rate contains total duration column.
   \item Validate if input enrollment rate contains rate column.
   \item Validate if input failure rate contains stratum column.
   \item Validate if input failure rate contains duration column.
   \item Validate if input failure rate contains failure rate column.
   \item Validate if input failure rate contains hazard ratio column.
   \item Validate if input failure rate contains dropout rate column.
   \item Validate if input trial total follow-up (total duration) is a non-empty vector of positive integers.
   \item Validate if strata is the same in enrollment rate and failure rate.
   \item Compute the proportion in each group.
   \item Compute the expected events by treatment groups, stratum and time period.
   \item Calculate the expected number of events for all time points in the total
    duration and for all stratification variables.
   \itemize{
     \item Compute the expected events in for each strata.
       \itemize{
         \item Combine the expected number of events of all stratification variables.
         \item Recompute events, hazard ratio and information under
         the given scenario of the combined data for each strata.
         }
       \item Combine the results for all time points by summarizing the results by adding up the number of events,
      information under the null and the given scenarios.
      }
   \item Return a tibble of overall event count, statistical information and average hazard ratio
   of each value in total_duration.
   \item Calculation of \code{ahr} for different design scenarios, and the comparison to the
   simulation studies are defined in vignette/AHRVignette.Rmd.
  }
}
\if{html}{The contents of this section are shown in PDF user manual only.}
}

\examples{
# Example: default
ahr()

# Example: default with multiple analysis times (varying total_duration)
ahr(total_duration = c(15, 30))

# Stratified population
enroll_rate <- define_enroll_rate(
  stratum = c(rep("Low", 2), rep("High", 3)),
  duration = c(2, 10, 4, 4, 8),
  rate = c(5, 10, 0, 3, 6)
)
fail_rate <- define_fail_rate(
  stratum = c(rep("Low", 2), rep("High", 2)),
  duration = 1,
  fail_rate = c(.1, .2, .3, .4),
  dropout_rate = .001,
  hr = c(.9, .75, .8, .6)
)
ahr(enroll_rate = enroll_rate, fail_rate = fail_rate, total_duration = c(15, 30))
}
