% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decimate.R
\name{decimate}
\alias{decimate}
\title{Decrease sample rate}
\usage{
decimate(x, q, n = ifelse(ftype == "iir", 8, 30), ftype = "iir")
}
\arguments{
\item{x}{input data, specified as a numeric vector or matrix. In case of a
vector it represents a single signal; in case of a matrix each column is a
signal.}

\item{q}{decimation factor, specified as a positive integer.}

\item{n}{Order of the filter used prior to the downsampling, specified as a
positive integer. Default: 8 if \code{ftype} equals \code{"iir"}; 30 of
\code{ftype} equals \code{"fir"}.}

\item{ftype}{filter type; either \code{"fir"}, specifying a FIR filter of
length \code{n} designed with the function \code{\link{fir1}}, or
\code{"iir"} (default), specifying an IIR Chebyshev filter of order 8 using
the function \code{\link{cheby1}}.}
}
\value{
downsampled signal, returned as a vector or matrix.
}
\description{
Downsample a signal by an integer factor.
}
\examples{
t <- seq(0, 2, 0.01)
x <- chirp(t, 2, .5, 10, 'quadratic') + sin(2 * pi * t * 0.4)
w <- 1:121
plot(t[w] * 1000, x[w], type = "h", col = "green")
points(t[w] * 1000, x[w], col = "green")
y = decimate(x, 4)
lines(t[seq(1, 121, 4)] * 1000, y[1:31], type = "h", col = "red")
points(t[seq(1, 121, 4)] * 1000, y[1:31], col = "red")

}
\seealso{
\code{\link{cheby1}}, \code{\link{fir1}}
}
\author{
Paul Kienzle, \email{pkienzle@users.sf.net}.\cr
  Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
