% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_enthalpy_first_derivatives}
\alias{gsw_enthalpy_first_derivatives}
\title{First Derivatives of Enthalpy}
\usage{
gsw_enthalpy_first_derivatives(SA, CT, p)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{CT}{Conservative Temperature [ degC ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}
}
\value{
a list containing \code{h_SA} [ (J/kg)/(g/kg) ], the derivative
of enthalpy wrt Absolute Salinity, and \code{h_CT} [ (J/kg)/degC ],
the derivative of enthalpy wrt Conservative Temperature.
}
\description{
First Derivatives of Enthalpy
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05 dated 2017-07-27, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '13ab33cea0e9059d3b3f3dfef78e9591c94af9f8'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
CT <- c(28.7856, 28.4329, 22.8103, 10.2600,  6.8863,  4.4036)
p <-  c(     10,      50,     125,     250,     600,    1000)
d <- gsw_enthalpy_first_derivatives(SA, CT, p)
expect_equal(d$h_SA, c(-0.070223912348929, -0.351159768365102, -0.887025065692568,
                     -1.829602387915694, -4.423463748270238, -7.405100077558673))
expect_equal(d$h_CT/1e3, c(3.991899705530481, 3.992025640520101, 3.992210365030743,
                         3.992284150250490, 3.992685389122658, 3.993014168534175))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_enthalpy_first_derivatives.html}
}
\seealso{
Other things related to enthalpy: \code{\link{gsw_CT_from_enthalpy}},
  \code{\link{gsw_dynamic_enthalpy}},
  \code{\link{gsw_enthalpy_CT_exact}},
  \code{\link{gsw_enthalpy_diff}},
  \code{\link{gsw_enthalpy_first_derivatives_CT_exact}},
  \code{\link{gsw_enthalpy_ice}},
  \code{\link{gsw_enthalpy_t_exact}},
  \code{\link{gsw_enthalpy}},
  \code{\link{gsw_frazil_properties_potential_poly}},
  \code{\link{gsw_frazil_properties_potential}},
  \code{\link{gsw_pot_enthalpy_from_pt_ice_poly}},
  \code{\link{gsw_pot_enthalpy_from_pt_ice}},
  \code{\link{gsw_pot_enthalpy_ice_freezing_poly}},
  \code{\link{gsw_pot_enthalpy_ice_freezing}},
  \code{\link{gsw_pt_from_pot_enthalpy_ice_poly}},
  \code{\link{gsw_pt_from_pot_enthalpy_ice}},
  \code{\link{gsw_specvol_first_derivatives_wrt_enthalpy}},
  \code{\link{gsw_specvol_first_derivatives}}
}
