% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_entropy_first_derivatives}
\alias{gsw_entropy_first_derivatives}
\title{First Derivatives of Entropy}
\usage{
gsw_entropy_first_derivatives(SA, CT)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{CT}{Conservative Temperature [ degC ]}
}
\value{
a list containing \code{eta_SA} [ (J/(kg*degC) / (g/kg) ],
the derivative of entropy wrt Absolute Salinity, and \code{eta_CT} [ (J/(kg*degC^2) ],
the derivative of entropy wrt Conservative Temperature.
}
\description{
First Derivatives of Entropy
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05 dated 2017-07-27, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '13ab33cea0e9059d3b3f3dfef78e9591c94af9f8'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
CT <- c(28.8099, 28.4392, 22.7862, 10.2262,  6.8272,  4.3236)
d <- gsw_entropy_first_derivatives(SA, CT)
expect_equal(d$eta_SA, c(-0.263286800711655, -0.263977276574528, -0.255367497912925,
                       -0.238066586439561, -0.234438260606436, -0.232820684341694))
expect_equal(d$eta_CT, c(13.221031210083824, 13.236911191313675, 13.489004628681361,
                       14.086599016583795, 14.257729576432077, 14.386429945649411))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_entropy_first_derivatives.html}
}
\seealso{
Other things related to entropy: \code{\link{gsw_CT_from_entropy}},
  \code{\link{gsw_entropy_from_pt}},
  \code{\link{gsw_entropy_from_t}},
  \code{\link{gsw_entropy_ice}},
  \code{\link{gsw_pt_from_entropy}}
}
