% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_kappa_ice}
\alias{gsw_kappa_ice}
\title{Isentropic Compressibility of Ice}
\usage{
gsw_kappa_ice(t, p)
}
\arguments{
\item{t}{in-situ temperature (ITS-90) [ degC ]}

\item{p}{sea pressure [dbar], i.e. absolute pressure [dbar] minus 10.1325 dbar}
}
\value{
isentropic compressibility of ice [ 1/Pa ] (not 1/dbar)
}
\description{
Calculate isentropic compressibility of ice, in 1/Pa.
}
\details{
The present R function works with a wrapper to a C function contained
within the GSW-C system (Version 3.05 dated 2017-07-27, available at
\url{https://github.com/TEOS-10/GSW-C},
as git commit '13ab33cea0e9059d3b3f3dfef78e9591c94af9f8'), which
stems from the GSW-Fortran system (\url{https://github.com/TEOS-10/GSW-Fortran})
which in turn stems from the GSW-Matlab system
(\url{https://github.com/TEOS-10/GSW-Matlab}).
Consult \url{http://www.teos-10.org} to learn more about
these software systems, their authorships, and the science behind
it all.
}
\examples{
t <- c(-10.7856, -13.4329, -12.8103, -12.2600,  -10.8863,  -8.4036)
p <- c(      10,       50,      125,      250,       600,     1000)
kappa <- gsw_kappa_ice(t, p)
expect_equal(kappa*1e9, c(0.112495239053936, 0.112070687842183, 0.112119091047584,
                        0.112126504739297, 0.112123513812840, 0.112262589530974))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_kappa_ice.html}
}
\seealso{
Other things related to compressibility: \code{\link{gsw_kappa_const_t_ice}},
  \code{\link{gsw_kappa_t_exact}}, \code{\link{gsw_kappa}}
}
