% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtsave.R
\name{gtsave}
\alias{gtsave}
\title{Save a \strong{gt} table as a file}
\usage{
gtsave(data, filename, path = NULL, ...)
}
\arguments{
\item{data}{\emph{The gt table data object}

\verb{obj:<gt_tbl>} // \strong{required}

This is the \strong{gt} table object that is commonly created through use of the
\code{\link[=gt]{gt()}} function.}

\item{filename}{\emph{Output filename}

\verb{scalar<character>} // \strong{required}

The file name to create on disk. Ensure that an extension compatible with
the output types is provided (\code{.html}, \code{.tex}, \code{.ltx}, \code{.rtf}, \code{.docx}). If
a custom save function is provided then the file extension is disregarded.}

\item{path}{\emph{Output path}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

An optional path to which the file should be saved (combined with
\code{filename}).}

\item{...}{\emph{Additional options}

\verb{<named arguments>}

All other options passed to the appropriate internal saving function.}
}
\value{
The file name (invisibly) if the export process is successful.
}
\description{
\code{gtsave()} makes it easy to save a \strong{gt} table to a file. The function
guesses the file type by the extension provided in the output filename,
producing either an HTML, PDF, PNG, LaTeX, RTF, or Word (.docx) file.
}
\details{
Output filenames with either the \code{.html} or \code{.htm} extensions will produce an
HTML document. In this case, we can pass a \code{TRUE} or \code{FALSE} value to the
\code{inline_css} option to obtain an HTML document with inlined CSS styles (the
default is \code{FALSE}). More details on CSS inlining are available at
\code{\link[=as_raw_html]{as_raw_html()}}. We can pass values to arguments in \code{\link[htmltools:save_html]{htmltools::save_html()}}
through the \code{...}. Those arguments are either \code{background} or \code{libdir},
please refer to the \strong{htmltools} documentation for more details on the use
of these arguments.

If the output filename is expressed with the \code{.rtf} extension then an RTF
file will be generated. In this case, there is an option that can be passed
through \code{...}: \code{page_numbering}. This controls RTF document page numbering
and, by default, page numbering is not enabled (i.e., \code{page_numbering = "none"}).

We can create an image file based on the HTML version of the \code{gt} table. With
the filename extension \code{.png}, we get a PNG image file. A PDF document can be
generated by using the \code{.pdf} extension. This process is facilitated by the
\strong{webshot2} package, so, this package needs to be installed before
attempting to save any table as an image file. There is the option of passing
values to the underlying \code{\link[webshot2:webshot]{webshot2::webshot()}} function through \code{...}. Some of
the more useful arguments for PNG saving are \code{zoom} (defaults to a scale
level of \code{2}) and \code{expand} (adds whitespace pixels around the cropped table
image, and has a default value of \code{5}), and \code{selector} (the default value is
\code{"table"}). There are several more options available so have a look at the
\strong{webshot2} documentation for further details.

If the output filename extension is either of \code{.tex}, \code{.ltx}, or \code{.rnw}, a
LaTeX document is produced. An output filename of \code{.rtf} will generate an RTF
document. The LaTeX and RTF saving functions don't have any options to pass
to \code{...}.

If the output filename extension is \code{.docx}, a Word document file is
produced. This process is facilitated by the \strong{rmarkdown} package, so this
package needs to be installed before attempting to save any table as a
\code{.docx} document.
}
\section{Examples}{


Using a small subset of the \code{\link{gtcars}} dataset, we can create a \strong{gt} table
with row labels. We'll add a stubhead label with the \code{\link[=tab_stubhead]{tab_stubhead()}}
function to describe what is in the stub.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tab_1 <-
  gtcars |>
  dplyr::select(model, year, hp, trq) |>
  dplyr::slice(1:5) |>
  gt(rowname_col = "model") |>
  tab_stubhead(label = "car")
}\if{html}{\out{</div>}}

Export the \strong{gt} table to an HTML file with inlined CSS (which is necessary
for including the table as part of an HTML email) using \code{gtsave()} and the
\code{inline_css = TRUE} option.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tab_1 |> gtsave(filename = "tab_1.html", inline_css = TRUE)
}\if{html}{\out{</div>}}

By leaving out the \code{inline_css} option, we get a more conventional HTML file
with embedded CSS styles.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tab_1 |> gtsave(filename = "tab_1.html")
}\if{html}{\out{</div>}}

Saving as a PNG file results in a cropped image of an HTML table. The amount
of whitespace can be set with the \code{expand} option.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tab_1 |> gtsave("tab_1.png", expand = 10)
}\if{html}{\out{</div>}}

Any use of the \code{.tex}, \code{.ltx}, or \code{.rnw} will result in the output of a LaTeX
document.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tab_1 |> gtsave("tab_1.tex")
}\if{html}{\out{</div>}}

With the \code{.rtf} extension, we'll get an RTF document.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tab_1 |> gtsave("tab_1.rtf")

}\if{html}{\out{</div>}}

With the \code{.docx} extension, we'll get a word/docx document.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tab_1 |> gtsave("tab_1.docx")
}\if{html}{\out{</div>}}
}

\section{Function ID}{

13-1
}

\section{Function Introduced}{

\code{v0.2.0.5} (March 31, 2020)
}

\seealso{
Other table export functions: 
\code{\link{as_gtable}()},
\code{\link{as_latex}()},
\code{\link{as_raw_html}()},
\code{\link{as_rtf}()},
\code{\link{as_word}()},
\code{\link{extract_body}()},
\code{\link{extract_cells}()},
\code{\link{extract_summary}()}
}
\concept{table export functions}
