% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sample_biobank_data.R
\name{get_sample_biobank_data}
\alias{get_sample_biobank_data}
\title{Get Sample (Biobank Data)}
\usage{
get_sample_biobank_data(
  draw = NULL,
  materialTypes = NULL,
  tissueSiteDetailIds = NULL,
  pathCategory = NULL,
  tissueSampleIds = NULL,
  sex = NULL,
  sortBy = "sampleId",
  sortDirection = "asc",
  searchTerm = NULL,
  sampleIds = NULL,
  subjectIds = NULL,
  ageBrackets = NULL,
  hardyScales = NULL,
  hasExpressionData = NULL,
  hasGenotype = NULL,
  page = 0,
  itemsPerPage = 250
)
}
\arguments{
\item{draw}{Integer.}

\item{materialTypes}{String, vector. Options: "Cells:Cell Line Viable",
"DNA:DNA Genomic", "DNA:DNA Somatic", "RNA:Total RNA", "Tissue:PAXgene
Preserved", "Tissue:PAXgene Preserved Paraffin-embedded", "Tissue:Fresh
Frozen Tissue".}

\item{tissueSiteDetailIds}{Character vector of IDs for tissues of interest.
Can be GTEx specific IDs (e.g. "Whole_Blood"; use
\code{\link[=get_tissue_site_detail]{get_tissue_site_detail()}} to see valid values) or Ontology IDs.}

\item{pathCategory}{Character vector. Options: "adenoma", "amylacea",
"atelectasis", "atherosclerosis", "atherosis", "atrophy", "calcification",
"cirrhosis", "clean_specimens", "congestion", "corpora_albicantia", "cyst",
"desquamation", "diabetic", "dysplasia", "edema", "emphysema",
"esophagitis", "fibrosis", "gastritis", "glomerulosclerosis", "goiter",
"gynecomastoid", "hashimoto", "heart_failure_cells", "hemorrhage",
"hepatitis", "hyalinization", "hypereosinophilia", "hyperplasia",
"hypertrophy", "hypoxic", "infarction", "inflammation", "ischemic_changes",
"macrophages", "mastopathy", "metaplasia", "monckeberg", "necrosis",
"nephritis", "nephrosclerosis", "no_abnormalities", "nodularity",
"pancreatitis", "pigment", "pneumonia", "post_menopausal", "prostatitis",
"saponification", "scarring", "sclerotic", "solar_elastosis",
"spermatogenesis", "steatosis", "sweat_glands", "tma".}

\item{tissueSampleIds}{Array of strings. A list of Tissue Sample ID(s).}

\item{sex}{String. Options: "male", "female".}

\item{sortBy}{String. Options: "sampleId", "ischemicTime", "aliquotId",
"tissueSampleId", "hardyScale", "pathologyNotes", "ageBracket",
"tissueSiteDetailId", "sex".}

\item{sortDirection}{String. Options: "asc", "desc". Default = "asc".}

\item{searchTerm}{String.}

\item{sampleIds}{Character vector. GTEx sample ID.}

\item{subjectIds}{Character vector. GTEx subject ID.}

\item{ageBrackets}{The age bracket(s) of the donors of interest. Options:
"20-29", "30-39", "40-49", "50-59", "60-69", "70-79".}

\item{hardyScales}{Character vector. A list of Hardy Scale(s) of interest.
Options: "Ventilator case", "Fast death - violent", "Fast death - natural
causes", "Intermediate death", "Slow death".}

\item{hasExpressionData}{Logical.}

\item{hasGenotype}{Logical.}

\item{page}{Integer (default = 0).}

\item{itemsPerPage}{Integer (default = 250).}
}
\value{
A tibble
}
\description{
\href{https://gtexportal.org/api/v2/redoc#tag/Biobank-Data-Endpoints/operation/get_sample_api_v2_biobank_sample_get}{GTEx Portal API documentation}
}
\examples{
\dontrun{
 get_sample_biobank_data(tissueSiteDetailIds = "Whole_Blood")
}
}
\seealso{
Other Biobank Data Endpoints: 
\code{\link{download}()}
}
\concept{Biobank Data Endpoints}
