% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_gtfs.R
\name{filter_by_day}
\alias{filter_by_day}
\title{Filter GTFS trips operating on given days}
\usage{
filter_by_day(gtfs_data, days)
}
\arguments{
\item{gtfs_data}{A list of data.tables read using gtfs2gps::reag_gtfs().}

\item{days}{A vector of selected week days written in the same way of column names
in calendar file of GTFS (sunday, monday, etc.).}
}
\value{
A filtered GTFS data with the trips only from the selected days.
}
\description{
Filter a GTFS data read using gtfs2gps::read_gtfs(). It removes the
trips operating in non-selected days. Note that it might produce
inconsistent outputs that can be removed by using gtfs2gps::remove_invalid().
}
\examples{
poa <- read_gtfs(system.file("extdata/poa.zip", package = "gtfs2gps"))

subset <- filter_by_day(poa, c("wednesday", "friday"))
}
