% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indent_key.R
\name{indent_key.fmt_table1}
\alias{indent_key.fmt_table1}
\title{Makes index of factors requiring indent from \code{fmt_table1} objects in Rmarkdown}
\usage{
\method{indent_key}{fmt_table1}(x, ...)
}
\arguments{
\item{x}{\code{fmt_table1} object}

\item{...}{further arguments passed to or from other methods}
}
\description{
Makes index of factors requiring indent from \code{fmt_table1} objects in Rmarkdown
}
\examples{
\donttest{
  t1 <-
    trial \%>\%
    fmt_table1() \%>\%
    bold_labels()

  knitr::kable(as_tibble(t1),
    row.names = FALSE,
    caption = "Table 1: Summary of Patient and Clinical Variables"
  ) \%>\%
    kableExtra::kable_styling(
      bootstrap_options = c("condensed"),
      font_size = 11,
      full_width = F
    ) \%>\%
    kableExtra::add_indent(indent_key(t1))
}

}
