% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inline_text.R
\name{inline_text.fmt_regression}
\alias{inline_text.fmt_regression}
\alias{inline_text.fmt_uni_regression}
\title{Report statistics from \code{fmt_regression} and \code{fmt_uni_regression} inline in an Rmarkdown document}
\usage{
\method{inline_text}{fmt_regression}(x, cell,
  stat = "{est} (95\% CI {ci}; {p_pvalue})", sep = ":", ...)

\method{inline_text}{fmt_uni_regression}(x, cell,
  stat = "{est} (95\% CI {ci}; {p_pvalue})", sep = ":", ...)
}
\arguments{
\item{x}{object of class \code{fmt_regression} or \code{fmt_uni_regression} object}

\item{cell}{identifier for which cell to return from the \code{fmt_regression} object}

\item{stat}{Statistic to report. User can access the primary estimate (\code{est}), the lower
and upper limit of the confidence interval (\code{ll} and \code{ul}), confidence interval (\code{ci}),
N (\code{N}), pvalue (\code{pvalue}), and pvalue with \code{p=} or \code{p<} appended (\code{p_pvalue}).
Default is \code{"{est} (95\% CI {ci}; {p_pvalue})"}}

\item{sep}{a character string to separate the terms}

\item{...}{further arguments passed from generic \code{inline_text()}}
}
\value{
Formatted descriptive statistics from a \code{fmt_regression} object
}
\description{
Report statistics from \code{fmt_regression} and \code{fmt_uni_regression} inline in an Rmarkdown document
}
\examples{
mod <- glm(response ~ age + grade + stage, trial, family = binomial(link = "logit")) \%>\%
  fmt_regression(exponentiate = TRUE)
inline_text(mod, "age")

inline_text(mod, "grade:III")

trial \%>\%
  fmt_uni_regression(
    method = "lm",
    y = "age"
  ) \%>\%
  inline_text("grade:II")
}
