% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort_filter_p.R
\name{sort_filter_p}
\alias{sort_filter_p}
\alias{sort_p}
\alias{filter_p}
\title{Sort and filter variables in table by p-values}
\usage{
sort_p(x, q = FALSE)

filter_p(x, q = FALSE, t = 0.05)
}
\arguments{
\item{x}{An object created using gtsummary functions}

\item{q}{Logical argument. When \code{TRUE} will the q-value column is used}

\item{t}{p-values/q-values less than or equal to this threshold
will be retained. Default is 0.05}
}
\description{
Sort and filter variables in table by p-values
}
\section{Example Output}{

\if{html}{Example 1}

\if{html}{\figure{sort_filter_p_ex1.png}{options: width=50\%}}

\if{html}{Example 2}

\if{html}{\figure{sort_p_ex2.png}{options: width=50\%}}
}

\examples{
# Example 1 ----------------------------------
sort_filter_p_ex1 <-
  trial \%>\%
  select(age, grade, response, trt) \%>\%
  tbl_summary(by = trt) \%>\%
  add_p() \%>\%
  filter_p(t = 0.8) \%>\%
  sort_p()

# Example 2 ----------------------------------
sort_p_ex2 <-
  glm(response ~ trt + grade, trial, family = binomial(link = "logit")) \%>\%
  tbl_regression(exponentiate = TRUE) \%>\%
  sort_p()
}
\author{
Karissa Whiting, Daniel D. Sjoberg
}
