% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-hbr.R
\docType{methods}
\name{inspect_window_dbScan,hbr-method}
\alias{inspect_window_dbScan}
\alias{inspect_window_dbScan,hbr-method}
\alias{inspect_window_dbScan.hbr}
\title{Clustering with the dbscan algorithm}
\usage{
\S4method{inspect_window_dbScan}{hbr}(object, window,
  minPts = object@min.cl.size, eps, plotkNN = T, plotCluster = T)
}
\arguments{
\item{object}{object of class \code{\link{hbr}} containing the results of 
reconstructed haplotype-blocks}

\item{window}{Number of the window, which should be inspected}

\item{minPts}{Number of minimum points in the eps region (for core points).
(default \code{min.cl.size} used for haplotype block reconstruction)}

\item{eps}{The size of the epsilon neighborhood. Defines the distance between
samples that built up a core cluster, for details see ?\code{dbscan} of
the \code{dbscan} package. (This value is only used for the \code{plotCluster} 
functionality.)}

\item{plotkNN}{Boolean indicating if the kNN distance plot should be printed
, for details see ?\code{kNNdistplot} of the \code{dbscan} package. Briefly,
the y-value where a bent in the curve is visible is a good indicator of the eps
value to choose for the given k = minPts.}

\item{plotCluster}{Boolean indicating if clusters identified with average
linkage clustering should be visualized in PCs.}
}
\description{
Performs clustering with the dbscan (Density-based spatial clustering 
of applications with noise) for all SNPs in a window 
after filtering (i.e. \code{\link{initialize_SNP_time_series}})
and visualizes found clusters based on principal components. 
NOTE: The clusters identified here are not nessesarily identical
with the clusters identified with average linkage clustering. Therefore
if haplotype reconstruction was done using average linkage clustering
the clusters shown here can be different from clusters of identified haplotype 
blocks.
}
\details{
Performs clustering with \href{https://CRAN.R-project.org/package=dbscan}{dbscan} 
(Density-based spatial clustering of applications with noise) for all SNPs in a window 
after filtering (i.e. \code{\link{initialize_SNP_time_series}})
and visualizes found clusters based on principal components. 
NOTE: The clusters identified here are not nessesarily identical
with the clusters identified with average linkage clustering. Therefore
if haplotype reconstruction was done using average linkage clustering
the clusters shown here can be different from clusters of identified haplotype 
blocks. This method is rather indendet for inspection and getting an idea
if haplotype reconstruction should rather be run using dbscan instead 
of average linkage clustering.

This package used the dbscan implementation of the package \href{https://CRAN.R-project.org/package=dbscan}{dbscan}
(Michael Hahsler) originally described by Ester et al. (1996).
}
\author{
Susanne U. Franssen
}
\seealso{
\code{\link{hbr}} \code{\link{ex_dat}} \code{\link{summary.hbr}} \code{\link{plot.hbr}} 
\code{\link{plot_cluster_trajectories}} \code{\link{plot_marker_trajectories}}
\code{\link{map}} \code{\link{rev_map}} \code{\link{markers}} \code{\link{plot_hbr_freq}}
\code{\link{inspect_window}} \code{\link{inspect_window_PCA}} \code{\link{inspect_window_avLink}}
\code{\link{number_hbr}}
}

