% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hawkes.R
\name{plot.hawkes}
\alias{plot.hawkes}
\title{Plot of a Hawkes process}
\usage{
\method{plot}{hawkes}(
  x,
  intensity = FALSE,
  precision = 1000,
  fun = NULL,
  repr = NULL,
  family = NULL,
  M = NULL,
  ...
)
}
\arguments{
\item{x}{Either: a numeric vector, sorted in ascending order; or an object of class "hawkes" output by function \code{hawkes}.}

\item{intensity}{(default = FALSE) A boolean - whether to represent the cluster representation (\code{FALSE}) or the intensity function (\code{TRUE}).}

\item{precision}{(default = 1e3) Number of points to plot.}

\item{fun}{(default = NULL) A numeric function - intensity (function) of the immigrant process.}

\item{repr}{(default = NULL) A non-negative numeric value - mean number of offsprings.}

\item{family}{(default = NULL) A character string "name" naming a distribution with corresponding distribution function \code{dname}, or directly the distribution function.}

\item{M}{(default = NULL) A non-negative numeric value - upper bound on \code{fun}(ignored if \code{fun} is a numeric value).}

\item{...}{Additional arguments passed on to the random generation function \code{dname}.}
}
\value{
None
}
\description{
Plots the realisation of a Hawkes process and either its cluster representation (\code{intensity=FALSE}, only available for a simulated Hawkes process) or its intensity function (\code{intensity=TRUE}).
}
\examples{
# Simulate an exponential Hawkes process with baseline intensity 1,
# reproduction mean 0.5 and exponential fertility function with rate 2.
x <- hawkes(10, fun=1, repr=0.5, family="exp", rate=2)
plot(x)
# Simulate a Hawkes process with baseline intensity function 1 + sin(x),
# reproduction mean 0.5 and custom [0,1]-triangular fertility function.
x <- hawkes(10, fun=function(y) {1+sin(y)}, M=2, repr=0.5,
            family=function(n) {1 - sqrt(1 - runif(n))})
plot(x, intensity=TRUE, family=function(y) ifelse(y>0 & y<1, 2-2*y, 0))
}
