% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop.r
\name{hql_drop}
\alias{hql_drop}
\title{Drop HDF groups, datasets, and attributes}
\description{
Drop a datset, attribute, or group from an HDF file.
}
\examples{
if(hql_is_loaded()){
  tf = tempfile(fileext = ".h5")
  hql_create_file(tf)

  hql_use_file(tf)
  x = rnorm(10)
  attr(x, "myattribute") = "some information"
  hql_write_dataset(x, "mygroup/mydataset")

  hql_drop_attribute("mygroup/mydataset/myattribute")
  hql_drop_dataset("mygroup/mydataset")
  hql_drop_group("mygroup")
  
  hql_close_file(tf)
}

}
