% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.r
\name{hql_read}
\alias{hql_read}
\alias{hql_read_dataset}
\alias{hql_read_attribute}
\alias{hql_read_all_attributes}
\title{Read HDF Dataset or Attribute}
\usage{
hql_read(what = c("DATASET", "ATTRIBUTE"), path, parallel = FALSE)

hql_read_dataset(path, include.attributes = TRUE, parallel = FALSE)

hql_read_attribute(path, parallel = FALSE)

hql_read_all_attributes(path, parallel = FALSE)
}
\arguments{
\item{path}{The location of the dataset, attribute, or group within the HDF file.}

\item{parallel}{Use parallel processing functionality.}

\item{include.attributes}{If \code{TRUE}, include the dataset attributes.}
}
\value{
A matrix.

The attribute value.

A named list of attributes.
}
\description{
Read a dataset or attribute from an HDF file into memory.

Generic helper for reading HDF objects into memory.
}
\section{Functions}{
\itemize{
\item \code{hql_read_dataset}: Read a dataset from an HDF file.

\item \code{hql_read_attribute}: Read a single attribute from an HDF file.

\item \code{hql_read_all_attributes}: Read attributes from an HDF file.
}}

\examples{
if(hql_is_loaded()){
  tf = tempfile(fileext = ".h5")
  hql_create_file(tf)

  hql_use_file(tf)
  x = matrix(rnorm(100), nrow = 20)
  hql_write_dataset(x, "dataset0")
  hql_write_attribute("normal", "dataset0/dist")
 y = month.name
 attr(y, "abbreviation") = month.abb
 attr(y, "number") = 1:12
 hql_write_dataset(y, "group1/dataset1")

hql_read_dataset("dataset0")
hql_read_dataset("group1/dataset1")
hql_read_attribute("group1/dataset1/abbreviation")
hql_read_all_attributes("group1/dataset1")

hql_close_file(tf)
}

}
\keyword{internal}
