% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.r
\name{hql_write}
\alias{hql_write}
\alias{hql_write_dataset}
\alias{hql_write_attribute}
\alias{hql_write_all_attributes}
\title{Write HDF Dataset or Attribute}
\usage{
hql_write_dataset(dataset, path, include.attributes = TRUE,
  overwrite = FALSE, parallel = FALSE)

hql_write_attribute(attribute, path, overwrite = FALSE,
  parallel = FALSE)

hql_write_all_attributes(attributes, path, overwrite = FALSE,
  parallel = FALSE)
}
\arguments{
\item{dataset}{The dataset to write. The object must be coercible
to an array.}

\item{path}{The location within the HDF file to write the dataset or attribute(s).}

\item{include.attributes}{If \code{TRUE}, write the dataset attributes.}

\item{overwrite}{If \code{TRUE}, overwrite existing dataset or attribute.}

\item{parallel}{Use parallel processing functionality.}

\item{attribute}{The attribute to write.}

\item{attributes}{A list of attributes to write.}
}
\description{
Write a dataset or attribute to an HDF file.
}
\section{Functions}{
\itemize{
\item \code{hql_write_dataset}: Write a dataset to an HDF file.

\item \code{hql_write_attribute}: Write an attribute to an HDF file.

\item \code{hql_write_all_attributes}: Write multiple attributes to an HDF file.
}}

\examples{
if(hql_is_loaded()){
  tf = tempfile(fileext = ".h5")
  hql_create_file(tf)

  hql_use_file(tf)
  x = matrix(rnorm(100), nrow = 20)
  hql_write_dataset(x, "dataset0")
  hql_write_attribute("normal", "dataset0/dist")

  y = month.name
  attr(y, "abbreviation") = month.abb
  hql_write_dataset(y, "group1/dataset1")

  hql_close_file(tf)
}

}
