% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rlassoEffects.R
\name{rlassoEffects}
\alias{rlassoEffect}
\alias{rlassoEffects}
\alias{rlassoEffects.default}
\alias{rlassoEffects.formula}
\title{rigorous Lasso for Linear Models: Inference}
\usage{
rlassoEffects(x, ...)

\method{rlassoEffects}{default}(x, y, index = c(1:ncol(x)),
  method = "partialling out", I3 = NULL, post = TRUE, ...)

\method{rlassoEffects}{formula}(formula, data, I, method = "partialling out",
  included = NULL, post = TRUE, ...)

rlassoEffect(x, y, d, method = "double selection", I3 = NULL, post = TRUE,
  ...)
}
\arguments{
\item{x}{matrix of regressor variables serving as controls and potential
treatments. For \code{rlassoEffect} it contains only controls, for \code{rlassoEffects} both controls and potential treatments. For \code{rlassoEffects} it must have at least two columns.}

\item{y}{outcome variable (vector or matrix)}

\item{index}{vector of integers, logicals or variables names indicating the position (column) of
variables (integer case), logical vector of length of the variables (TRUE or FALSE) or the variable names of \code{x} which should be used for inference / as treatment variables.}

\item{method}{method for inference, either 'partialling out' (default) or 'double selection'.}

\item{I3}{For the 'double selection'-method the logical vector \code{I3} has same length as the number of variables in \code{x};
indicates if variables (TRUE) should be included in any case to the model and they are exempt from selection. These variables should not be included in the \code{index}; hence the intersection with \code{index} must be the empty set.
In the case of partialling out it is ignored.}

\item{post}{logical, if post Lasso is conducted with default \code{TRUE}.}

\item{formula}{An element of class \code{formula} specifying the linear model.}

\item{data}{an optional data frame, list or environment (or object coercible by as.data.frame to a data frame) containing the variables in the model. 
If not found in data, the variables are taken from environment(formula), typically the environment from which the function is called.}

\item{I}{An one-sided formula specifying the variables for which inference is conducted.}

\item{included}{One-sided formula of variables which should be included in any case (only for method="double selection").}

\item{d}{variable for which inference is conducted (treatment variable)}

\item{\dots}{parameters passed to the \code{rlasso} function.}
}
\value{
The function returns an object of class \code{rlassoEffects} with the following entries: \item{coefficients}{vector with estimated
values of the coefficients for each selected variable} \item{se}{standard error (vector)}
\item{t}{t-statistic} \item{pval}{p-value} \item{samplesize}{sample size of the data set} \item{index}{index of the variables for which inference is performed}
}
\description{
Estimation and inference of (low-dimensional) target coefficients in a high-dimensional linear model.
}
\details{
The functions estimates (low-dimensional) target coefficients in a high-dimensional linear model.
An application is e.g. estimation of a treatment effect \eqn{\alpha_0} in a
setting of high-dimensional controls. The user can choose between the so-called post-double-selection method and partialling-out.
The idea of the double selection method is to select variables by Lasso regression of
the outcome variable on the control variables and the treatment variable on
the control variables. The final estimation is done by a regression of the
outcome on the treatment effect and the union of the selected variables in
the first two steps. In partialling-out first the effect of the regressors on the outcome and the treatment variable is taken out by Lasso and then a regression of the residuals is conducted. The resulting estimator for \eqn{\alpha_0} is normal
distributed which allows inference on the treatment effect. It presents a wrap function for \code{rlassoEffect} 
which does inference for a single variable.
}
\examples{
library(hdm); library(ggplot2)
set.seed(1)
n = 100 #sample size
p = 100 # number of variables
s = 3 # nubmer of non-zero variables
X = matrix(rnorm(n*p), ncol=p)
colnames(X) <- paste("X", 1:p, sep="")
beta = c(rep(3,s), rep(0,p-s))
y = 1 + X\%*\%beta + rnorm(n)
data = data.frame(cbind(y,X))
colnames(data)[1] <- "y"
fm = paste("y ~", paste(colnames(X), collapse="+"))
fm = as.formula(fm)                 
lasso.effect = rlassoEffects(X, y, index=c(1,2,3,50))
lasso.effect = rlassoEffects(fm, I = ~ X1 + X2 + X3 + X50, data=data)
print(lasso.effect)
summary(lasso.effect)
confint(lasso.effect)
}
\references{
A. Belloni, V. Chernozhukov, C. Hansen (2014). Inference on
treatment effects after selection among high-dimensional controls. The
Review of Economic Studies 81(2), 608-650.
}

