% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nc.hdsvm-methods.R
\name{coef.nc.hdsvm}
\alias{coef.nc.hdsvm}
\title{Extract Model Coefficients from a `nc.hdsvm` Object}
\usage{
\method{coef}{nc.hdsvm}(object, s = NULL, type = c("coefficients", "nonzero"), ...)
}
\arguments{
\item{object}{Fitted `nc.hdsvm()` object.}

\item{s}{Values of the penalty parameter `lambda` for which coefficients are requested.
Defaults to the entire sequence used during the model fit.}

\item{type}{Type of prediction required. Type `"coefficients"` computes the coefficients at the requested 
values for `s`. Type `"nonzero"` returns a list of the indices of the nonzero coefficients for each 
value of \code{s}.}

\item{...}{Not used.}
}
\value{
Returns a matrix or vector of coefficients corresponding to the specified `lambda` values.
}
\description{
Retrieves the coefficients at specified values of `lambda` from a fitted `nc.hdsvm()` model.
}
\details{
This function extracts coefficients for specified `lambda` values from a `nc.hdsvm()` object.
If `s`, the vector of `lambda` values, contains values not originally used in the model fitting,
the `coef` function employs linear interpolation between the closest `lambda` values from the 
original sequence to estimate coefficients at the new `lambda` values.
}
\examples{
set.seed(315)
n <- 100
p <- 400
x1 <- matrix(rnorm(n / 2 * p, -0.25, 0.1), n / 2)
x2 <- matrix(rnorm(n / 2 * p, 0.25, 0.1), n / 2)
x <- rbind(x1, x2)
beta <- 0.1 * rnorm(p)
prob <- plogis(c(x \%*\% beta))
y <- 2 * rbinom(n, 1, prob) - 1
lam2 <- 0.01
lambda <- 10^(seq(1,-4, length.out = 30)) 
nc.fit <- nc.hdsvm(x = x, y = y, lambda = lambda, lam2 = lam2, pen = "scad")
nc.coefs <- coef(nc.fit, s = nc.fit$lambda[3:5])
}
\seealso{
\code{\link{nc.hdsvm}}, \code{\link{predict.nc.hdsvm}}
}
