% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.R
\name{countDaysSinceFirstDate}
\alias{countDaysSinceFirstDate}
\title{Creates column based on days since first date}
\usage{
countDaysSinceFirstDate(df, dtCol, returnDtCol = FALSE)
}
\arguments{
\item{df}{A data frame}

\item{dtCol}{A string denoting the date-time column of interest}

\item{returnDtCol}{A boolean. Return the original dtCol with the modified
data frame?}
}
\value{
A data frame that now has a new column
}
\description{
Adds a new column to the data frame, which shows days since
first day in input column
}
\examples{
dtCol = c('2001-06-09 12:45:05','2002-01-29 09:30:05','2002-02-02 07:36:50',
'2002-03-04 16:45:01','2002-11-13 20:00:10','2003-01-29 07:31:43',
'2003-07-07 17:30:02','2003-09-28 01:03:20')
y1 <- c(.5,1,3,6,8,13,14,1) # Not being used at all
df <- data.frame(dtCol, y1)
head(df)
dfResult <- countDaysSinceFirstDate(df, 'dtCol')
head(dfResult)
}
\references{
\url{http://healthcare.ai}
}
\seealso{
\code{\link{healthcareai}}
}
