% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.R
\name{writeData}
\alias{writeData}
\title{Write data to database}
\usage{
writeData(MSSQLConnectionString = NULL, df, SQLiteFileName = NULL,
  tableName)
}
\arguments{
\item{MSSQLConnectionString}{A string specifying the driver, server, 
database, and whether Windows Authentication will be used.}

\item{df}{Dataframe that hold the tabular data}

\item{SQLiteFileName}{A string. If dbtype is SQLite, here one specifies the 
database file to query from}

\item{tableName}{String. Name of the table that receives the new rows}
}
\value{
Nothing
}
\description{
Write data frame to database table via ODBC connection
#' @param connectionString A string specifying the driver, server, database,
and whether Windows Authentication will be used.
}
\examples{

\donttest{
# This example is specific to SQL Server.

# To instead pull data from Oracle see here 
# https://cran.r-project.org/web/packages/ROracle/ROracle.pdf
# To pull data from MySQL see here 
# https://cran.r-project.org/web/packages/RMySQL/RMySQL.pdf
# To pull data from Postgres see here 
# https://cran.r-project.org/web/packages/RPostgreSQL/RPostgreSQL.pdf 

# Before running this example, create the table in SQL Server via
# CREATE TABLE [dbo].[HCRWriteData](
# [a] [float] NULL,
# [b] [float] NULL,
# [c] [varchar](255) NULL)

connectionString <- '
  driver={SQL Server};
  server=localhost;
  database=SAM;
  trustedConnection=true
  '

df <- data.frame(a=c(1,2,3),
                 b=c(2,4,6),
                 c=c('one','two','three'))

writeData(MSSQLConnectionString = connectionString, 
          df = df, 
          tableName = 'HCRWriteData')
}
}
\references{
\url{http://healthcare.ai}
}
\seealso{
\code{\link{healthcareai}}
}
