% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup_hyperparameters.R
\name{get_hyperparameter_defaults}
\alias{get_hyperparameter_defaults}
\alias{hyperparameters}
\alias{get_random_hyperparameters}
\title{Get hyperparameter values}
\usage{
get_hyperparameter_defaults(models = get_supported_models(), n = 100,
  k = 10, model_class = "classification")

get_random_hyperparameters(models = get_supported_models(), n = 100,
  k = 10, tune_depth = 5, model_class = "classification")
}
\arguments{
\item{models}{which algorithms?}

\item{n}{Number observations}

\item{k}{Number features}

\item{model_class}{"classification" or "regression"}

\item{tune_depth}{How many combinations of hyperparameter values?}
}
\value{
Named list of data frames. Each data frame corresponds to an
 algorithm, and each column in each data fram corresponds to a hyperparameter
 for that algorithm. This is the same format that should be provided to
 \code{tune_models(hyperparameters = )} to specify hyperparameter values.
}
\description{
Get hyperparameter values
}
\details{
Get hyperparameters for model training.
 \code{get_hyperparameter_defaults} returns a list of 1-row data frames with
 default hyperparameter values that are used by \code{flash_models}.
 \code{get_random_hyperparameters} returns a list of data frames with
 combinations of random values of hyperparameters to tune over in
 \code{tune_models}; the number of rows in the data frames is given by
 `tune_depth`.

 For \code{get_hyperparameter_defaults} k-NN defaults are from the kknn
 package: kmax = 7, distance = 2 (Minkowski's exponent, i.e. Euclidean
 distance), kernal = "optimal". Random forest defaults are from Intro to
 Statistical Learning and caret: mtry = sqrt(k), splitrule = "extratrees",
 min.node.size = 1 for classification, 5 for regression
}
\seealso{
\code{\link{models}} for model and hyperparameter details
}
