% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/restrict_n.R
\name{restrict_n}
\alias{restrict_n}
\title{Removes or flags groups with n less than some number}
\usage{
restrict_n(
  data,
  clnt_id,
  n_per_clnt,
  count_by = NULL,
  mode = c("flag", "filter"),
  verbose = getOption("healthdb.verbose")
)
}
\arguments{
\item{data}{Data.frames or remote tables (e.g., from \verb{vignette("dbplyr", package = "dbplyr)})}

\item{clnt_id}{Grouping variable (quoted/unquoted).}

\item{n_per_clnt}{A single number specifying the minimum number of group size.}

\item{count_by}{Another variable dictating the counting unit of \code{n_per_clnt.} The default is NULL meaning the inclusion criteria is the number of row, i.e., \code{dplyr::n() >= n_per_clnt}. If it is not NULL, the criteria becomes equivalent to \code{dplyr::n_distinct(count_by) >= n_per_clnt}.}

\item{mode}{Either "flag" - add a new column 'flag_restrict_n' indicating if the client met the condition (all rows from a qualified client would have flag = 1), or "filter" - remove clients that did not meet the condition from the data. Default is "flag".}

\item{verbose}{A logical for whether to explain the query and report how many groups were removed. Default is fetching from options. Use \code{options(healthdb.verbose = FALSE)} to suppress once and for all. Reporting is not for remote tables as the query is not executed immediately, thus no result is available for summary without adding an extra run (may be slow) of the query.}
}
\value{
A subset of input data satisfied the group size requirement, or raw input data with an new flag column.
}
\description{
Remove or flags groups or clients that have less than some number of rows or some number of distinct values in a variable. For example, it can be used to remove clients that had less than n visits to some service on different dates from some administrative records. It offers filtering with \code{\link[dplyr:n_distinct]{dplyr::n_distinct()}} functionality for database input.
}
\examples{
#remove cyl groups with less than 8 cars
restrict_n(mtcars, clnt_id = cyl, n_per_clnt = 8)

#remove cyl groups with less than 2 types of gear boxes
restrict_n(mtcars, clnt_id = cyl, n_per_clnt = 3, count_by = gear)
}
\seealso{
\code{\link[dplyr:context]{dplyr::n()}}, \code{\link[dplyr:n_distinct]{dplyr::n_distinct()}}
}
