% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfr_kswin.R
\name{dfr_kswin}
\alias{dfr_kswin}
\title{KSWIN method}
\usage{
dfr_kswin(
  target_feat,
  window_size = 100,
  stat_size = 30,
  alpha = 0.005,
  data = NULL
)
}
\arguments{
\item{target_feat}{Feature to be monitored.}

\item{window_size}{Size of the sliding window (must be > 2*stat_size)}

\item{stat_size}{Size of the statistic window}

\item{alpha}{Probability for the test statistic of the Kolmogorov-Smirnov-Test The alpha parameter is very sensitive, therefore should be set below 0.01.}

\item{data}{Already collected data to avoid cold start.}
}
\value{
\code{dfr_kswin} object
}
\description{
Kolmogorov-Smirnov Windowing method for concept drift detection \url{doi:10.1016/j.neucom.2019.11.111}.
}
\examples{
library(daltoolbox)
library(heimdall)

# This example assumes a model residual where 1 is an error and 0 is a correct prediction.

data(st_drift_examples)
data <- st_drift_examples$univariate
data$event <- NULL
data$prediction <- st_drift_examples$univariate$serie > 4


model <- dfr_kswin(target_feat='serie')

detection <- c()
output <- list(obj=model, pred=FALSE)
for (i in 1:length(data$serie)){
 output <- update_state(output$obj, data$serie[i])
 if (output$pred){
   type <- 'drift'
   output$obj <- reset_state(output$obj)
 }else{
   type <- ''
 }
 detection <- rbind(detection, list(idx=i, event=output$pred, type=type))
}

detection <- as.data.frame(detection)
detection[detection$type == 'drift',]
}
