% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mark.H0.R
\name{mark.H0}
\alias{mark.H0}
\title{Mark a point null hypothesis in an HE plot}
\usage{
mark.H0(
  x = 0,
  y = 0,
  z = NULL,
  label,
  cex = 2,
  pch = 19,
  col = "green3",
  lty = 2,
  pos = 2
)
}
\arguments{
\item{x}{Horizontal coordinate for H0}

\item{y}{Vertical coordinate for H0}

\item{z}{z coordinate for H0.  If not NULL, the function assumes that a
\code{heplot3d} plot has been drawn.}

\item{label}{Text used to label the point. Defaults to
\code{expression(H[0])} in 2D plots.}

\item{cex}{Point and text size.  For 3D plots, the function uses
\code{size=5*cex} in a call to \code{\link[rgl]{points3d}}.}

\item{pch}{Plot character.  Ignored for 3D plots.}

\item{col}{Color for text, character and lines}

\item{lty}{Line type for vertical and horizontal reference lines. Not drawn if \code{lty}=0.}

\item{pos}{Position of text.  Ignored for 3D plots}
}
\value{
None. Used for side effect of drawing on the current plot.
}
\description{
A utility function to draw and label a point in a 2D (or 3D) HE plot
corresponding to a point null hypothesis being tested. This is most useful
for repeated measure designs where null hypotheses for within-S effects
often correspond to (0,0).
}
\examples{

Vocab.mod <- lm(cbind(grade8,grade9,grade10,grade11) ~ 1, data=VocabGrowth)
idata <-data.frame(grade=ordered(8:11))

heplot(Vocab.mod, type="III", idata=idata, idesign=~grade, iterm="grade",
	main="HE plot for Grade effect")
mark.H0()

}
\seealso{
\code{\link{cross3d}}
}
\author{
Michael Friendly
}
\keyword{aplot}
