% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxM.R
\name{boxM}
\alias{boxM}
\alias{boxM.formula}
\alias{boxM.lm}
\alias{boxM.default}
\alias{summary.boxM}
\title{Box's M-test}
\usage{
boxM(Y, ...)

\method{boxM}{default}(Y, group, ...)

\method{boxM}{formula}(Y, data, ...)

\method{boxM}{lm}(Y, ...)

\method{summary}{boxM}(object, digits = getOption("digits"), cov = FALSE, quiet = FALSE, ...)
}
\arguments{
\item{Y}{The response variable matrix for the default method, or a
\code{"mlm"} or \code{"formula"} object for a multivariate linear model.  If
\code{Y} is a linear-model object or a formula, the variables on the
right-hand-side of the model must all be factors and must be completely
crossed, e.g., \code{A:B}}

\item{...}{Arguments passed down to methods.}

\item{group}{a factor defining groups, or a vector of length \emph{n} doing
the same.}

\item{data}{a numeric data.frame or matrix containing \emph{n} observations
of \emph{p} variables; it is expected that \emph{n > p}.}

\item{object}{a \code{"boxM"} object for the \code{summary} method}

\item{digits}{number of digits to print for the \code{summary} method}

\item{cov}{logical; if \code{TRUE} the covariance matrices are printed.}

\item{quiet}{logical; if \code{TRUE} printing from the \code{summary} is
suppressed}
}
\value{
A list with class \code{c("htest", "boxM")} containing the following
components: 
\item{statistic }{an approximated value of the chi-square
distribution.} 
\item{parameter }{the degrees of freedom related of the test
statistic in this case that it follows a Chi-square distribution.}
\item{p.value }{the p-value of the test.} 
\item{cov }{a list containing the
within covariance matrix for each level of \code{grouping}.} 
\item{pooled}{the pooled covariance matrix.} 
\item{logDet }{a vector containing the natural logarithm of each matrix in \code{cov}, followed by the value for
the pooled covariance matrix} 
\item{means}{a matrix of the means for all groups, followed by the grand means} 
\item{df}{a vector of the degrees of freedom for all groups, followed by that for the pooled covariance matrix}
\item{data.name }{a character string giving the names of the data.}
\item{method }{the character string "Box's M-test for Homogeneity of
Covariance Matrices".}
}
\description{
\code{boxM} performs the Box's (1949) M-test for homogeneity of covariance
matrices obtained from multivariate normal data according to one or more
classification factors. The test compares the product of the log
determinants of the separate covariance matrices to the log determinant of
the pooled covariance matrix, analogous to a likelihood ratio test. The test
statistic uses a chi-square approximation.
}
\details{
As an object of class \code{"htest"}, the statistical test is printed
normally by default. As an object of class \code{"boxM"}, a few methods are
available.

There is no general provision as yet for handling missing data.  Missing
data are simply removed, with a warning.

As well, the computation assumes that the covariance matrix for each group
is non-singular, so that \eqn{log det(S_i)} can be calculated for each
group. At the minimum, this requires that \eqn{n > p} for each group.

Box's M test for a multivariate linear model highly sensitive to departures
from multivariate normality, just as the analogous univariate test.  It is
also affected adversely by unbalanced designs.  Some people recommend to
ignore the result unless it is very highly significant, e.g., p < .0001 or
worse.

The \code{summary} method prints a variety of additional statistics based on
the eigenvalues of the covariance matrices.  These are returned invisibly,
as a list containing the following components: 
\itemize{ 
\item \code{logDet} - log determinants 
\item \code{eigs} - eigenvalues of the covariance matrices 
\item \code{eigstats} - statistics computed on the eigenvalues for each covariance matrix:\cr 
    \code{product}: the product of eigenvalues, \eqn{\prod{\lambda_i}};\cr 
    \code{sum}: the sum of eigenvalues, \eqn{\sum{\lambda_i}};\cr 
    \code{precision}: the average precision of eigenvalues, \eqn{1/\sum(1/\lambda_i)};\cr 
    \code{max}: the maximum eigenvalue, \eqn{\lambda_1} 
}
}
\examples{

data(iris)

# default method
res <- boxM(iris[, 1:4], iris[, "Species"])
res

# summary method gives details
summary(res)

# visualize (what is done in the plot method) 
dets <- res$logDet
ng <- length(res$logDet)-1
dotchart(dets, xlab = "log determinant")
points(dets , 1:4,  
	cex=c(rep(1.5, ng), 2.5), 
	pch=c(rep(16, ng), 15),
	col= c(rep("blue", ng), "red"))
	
	# plot method gives confidence intervals for logDet
plot(res, gplabel="Species")

# formula method
boxM( cbind(Sepal.Length, Sepal.Width, Petal.Length, Petal.Width) ~ Species, data=iris)

### Skulls dat
data(Skulls)
# lm method
skulls.mod <- lm(cbind(mb, bh, bl, nh) ~ epoch, data=Skulls)
boxM(skulls.mod)




}
\references{
Box, G. E. P. (1949). A general distribution theory for a class
of likelihood criteria. \emph{Biometrika}, 36, 317-346.

Morrison, D.F. (1976) \emph{Multivariate Statistical Methods}.
}
\seealso{
\code{\link[car]{leveneTest}} carries out homogeneity of variance
tests for univariate models with better statistical properties.

\code{\link{plot.boxM}}, a simple plot of the log determinants

\code{\link{covEllipses}} plots covariance ellipses in variable space for
several groups.
}
\author{
The default method was taken from the \pkg{biotools} package,
Anderson Rodrigo da Silva \email{anderson.agro@hotmail.com}

Generalized by Michael Friendly and John Fox
}
