% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hermite_estimator.R
\name{hcdf}
\alias{hcdf}
\title{Creates an object summarizing the CDF with associated generic methods print,
plot and summary.}
\usage{
hcdf(
  h_est_obj,
  clipped = FALSE,
  accelerate_series = TRUE,
  x_lower = NA,
  x_upper = NA
)
}
\arguments{
\item{h_est_obj}{A hermite_estimator_univar or hermite_estimator_bivar 
object.}

\item{clipped}{A boolean value. This value determines whether
cumulative probabilities are clipped to lie between 0 and 1.}

\item{accelerate_series}{A boolean value. This value determines whether
Hermite series acceleration is applied.}

\item{x_lower}{A numeric value (univariate) or a numeric vector (bivariate).
This value determines the lower limit of x values at which to evaluate 
the CDF.}

\item{x_upper}{A numeric value (univariate) or a numeric vector (bivariate).
This value determines the upper limit of x values at which to evaluate 
the CDF.}
}
\value{
A hcdf_univar or hcdf_bivar object.
}
\description{
The h_est_obj object must be updated with observations prior to the use of 
the method.
}
