% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hermite_estimator_bivar.R
\name{hcdf.hermite_estimator_bivar}
\alias{hcdf.hermite_estimator_bivar}
\title{Creates an object summarizing the bivariate CDF with associated generic 
methods print, plot and summary.}
\usage{
\method{hcdf}{hermite_estimator_bivar}(
  h_est_obj,
  clipped = FALSE,
  accelerate_series = TRUE,
  x_lower = NA,
  x_upper = NA
)
}
\arguments{
\item{h_est_obj}{A hermite_estimator_bivar object.}

\item{clipped}{A boolean value. This value determines whether cumulative
probabilities are clipped to lie within the range [0,1].}

\item{accelerate_series}{A boolean value. This value determines whether
Hermite series acceleration is applied.}

\item{x_lower}{A numeric vector. This vector determines the lower limit of 
x values at which to evaluate the CDF.}

\item{x_upper}{A numeric value. This vector determines the upper limit of 
x values at which to evaluate the CDF.}
}
\value{
A hcdf_bivar object whose underlying structure is a list 
containing the following components.

x: The points at which the cumulative probability is calculated.
x_vals_1: Marginal quantiles of first random variable, used for plotting.
x_vals_2: Marginal quantiles of second random variable, used for plotting.
cum_prob_vals: The cumulative probability values at the points x.
num_obs: The number of observations used to form the Hermite cumulative 
probability estimates.
N: The number of terms N in the Hermite series estimator.
}
\description{
The hermite_estimator_bivar object h_est_obj must be updated with 
observations prior to the use of this method.
}
