% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.data3d.R
\name{generate.data3d}
\alias{generate.data3d}
\alias{generate_data3d}
\alias{generateData3d}
\alias{GenerateData3d}
\title{Generate 3d data}
\usage{
generate.data3d()

generate_data3d()

generateData3d()

GenerateData3d()
}
\value{
A list with components \code{x}, \code{mu3d}, and
\code{data3d}.  \code{x} is a list of sequences with
  length 128, 128, and 24.  \code{mu3d} and \code{data3d}
  are arrays of size 128 by 128 by 24.
}
\description{
Generate data related to Section 7.2 of Lu et al. (2012)
(code from author).  Define \code{n = c(128,
  128, 24)}.  Then \code{x[[i]] = (1:n[i])/n[i] -
  1/2/n[i]}.  These are the observed data locations. For
  \code{i}, \code{j}, \code{k} spanning the full length
  of each element of \code{x}, \code{mu3d[i, j, k] =
  x[[1]][i]^2 + x[[2]][j]^2 + x[[3]][k]^2}.  Lastly,
  \code{data3d = mu3d + 0.5 * rnorm(n[1] * n[2] * n[3])}.
}
\examples{
dat = generate.data3d()
}
\references{
Xiao, L. , Li, Y. and Ruppert, D. (2013),
  Fast bivariate P-splines: the sandwich smoother. J. R.
  Stat. Soc. B, 75: 577-599. <doi:10.1111/rssb.12007>
}
\author{
Joshua French.  Based off code by Luo Xiao (see
  References).
}
