% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/params.R
\name{create_params}
\alias{create_params}
\alias{create_params.lm}
\alias{create_params.flexsurvreg}
\alias{create_params.multinom}
\alias{create_params.multinom_list}
\alias{create_params.flexsurvreg_list}
\alias{create_params.partsurvfit}
\title{Create a parameter object from a fitted model}
\usage{
create_params(object, ...)

\method{create_params}{lm}(object, n = 1000, uncertainty = c("normal", "none"), ...)

\method{create_params}{flexsurvreg}(object, n = 1000, uncertainty = c("normal", "none"), ...)

\method{create_params}{multinom}(object, n = 1000, uncertainty = c("normal", "none"), ...)

\method{create_params}{multinom_list}(object, n = 1000, uncertainty = c("normal", "none"), ...)

\method{create_params}{flexsurvreg_list}(object, n = 1000, uncertainty = c("normal", "none"), ...)

\method{create_params}{partsurvfit}(
  object,
  n = 1000,
  uncertainty = c("normal", "bootstrap", "none"),
  ...
)
}
\arguments{
\item{object}{A statistical model to randomly sample parameters from.}

\item{...}{Further arguments passed to or from other methods. Only used when
\code{object} is of class \code{partsurvfit}, in which case the arguments are passed
to \code{\link[=bootstrap.partsurvfit]{bootstrap.partsurvfit()}}.}

\item{n}{Number of random observations to draw. Not used if \code{uncertainty = "none"}.}

\item{uncertainty}{Method determining how parameter uncertainty should be handled.
If \code{"normal"}, then parameters are randomly drawn from their multivariate normal
distribution. If \verb{"bootstrap}, then parameters are bootstrapped using \code{\link{bootstrap}}.
If \verb{"none}, then only point estimates are returned.}
}
\value{
An object prefixed by \code{params_}. Mapping between \code{create_params}
and the classes of the returned objects are:
\itemize{
\item{\code{create_params.lm} ->}{ \code{\link{params_lm}}}
\item{\code{create_params.multinom} ->}{ \code{\link{params_mlogit}}}
\item{\code{create_params.multinom_list} ->}{ \code{\link{params_mlogit_list}}}
\item{\code{create_params.flexsurvreg} ->}{ \code{\link{params_surv}}}
\item{\code{create_params.flexsurvreg_list} ->}{ \code{\link{params_surv_list}}}
\item{\code{create_params.partsurvfit} ->}{ \code{\link{params_surv_list}}}
}
}
\description{
\code{create_params} is a generic function for creating an object containing
parameters from a fitted statistical model. If \code{uncertainty != "none"},
then random samples from suitable probability distributions are returned.
}
\examples{
# create_params.lm
fit <- stats::lm(costs ~ female, data = psm4_exdata$costs$medical)
n <- 5
params_lm <- create_params(fit, n = n)
head(params_lm$coefs)
head(params_lm$sigma)

# create_params.flexsurvreg
library("flexsurv")
fit <- flexsurv::flexsurvreg(formula = Surv(futime, fustat) ~ 1, 
                    data = ovarian, dist = "weibull")
n <- 5
params_surv_wei <- create_params(fit, n = n)
print(params_surv_wei$dist)
head(params_surv_wei$coefs)
}
