% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_ceac}
\alias{plot_ceac}
\alias{plot_ceac.cea_pw}
\alias{plot_ceac.cea}
\title{Plot cost-effectiveness acceptability curve}
\usage{
plot_ceac(x, ...)

\method{plot_ceac}{cea_pw}(x, labels = NULL, ...)

\method{plot_ceac}{cea}(x, labels = NULL, ...)
}
\arguments{
\item{x}{An object of the appropriate class.}

\item{...}{Further arguments passed to and from methods. Currently unused.}

\item{labels}{A list of named vectors containing the values and labels of
variables. The elements of each vector are the values of a variable and the
names are the labels. The names of the list are the names of the variables.
See the output returned by \code{\link[=get_labels]{get_labels()}} for an example.}
}
\description{
Plot a cost-effectiveness curve from either the output of \code{\link[=cea]{cea()}} or
\code{\link[=cea_pw]{cea_pw()}} using \code{\link[ggplot2:ggplot]{ggplot2::ggplot}}. The former compares all treatment strategies
simultaneously and uses the probabilistic sensitivity analysis (PSA) to compute
the probability that each strategy is the most cost-effective at a given
willingness to pay value, while the latter uses the PSA to compute the probability
that each treatment is cost-effective relative to a comparator.
}
\details{
See the \code{\link[=cea]{cea()}} documentation for an example. If there are multiple subgroups,
then a faceted plot is produced with one plot for each subgroup.
}
