% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hetGP.R
\name{predict.hetGP}
\alias{predict.hetGP}
\title{Gaussian process predictions using a heterogeneous noise GP object (of class \code{hetGP})}
\usage{
\method{predict}{hetGP}(object, x, noise.var = FALSE, xprime = NULL,
  nugs.only = FALSE, ...)
}
\arguments{
\item{object}{an object of class \code{hetGP}; e.g., as returned by \code{\link[hetGP]{mleHetGP}}}

\item{x}{matrix of designs locations to predict at (one point per row)}

\item{noise.var}{should the variance of the latent variance process be returned?}

\item{xprime}{optional second matrix of predictive locations to obtain the predictive covariance matrix between \code{x} and \code{xprime}}

\item{nugs.only}{if \code{TRUE}, only return noise variance prediction}

\item{...}{no other argument for this method.}
}
\value{
list with elements
\itemize{
\item \code{mean}: kriging mean;
\item \code{sd2}: kriging variance (filtered, e.g. without the nugget values)
\item \code{nugs}: noise variance prediction
\item \code{sd2_var}: (returned if \code{noise.var = TRUE}) kriging variance of the noise process (i.e., on log-variances if \code{logN = TRUE})
\item \code{cov}: (returned if \code{xprime} is given) predictive covariance matrix between \code{x} and \code{xprime}
}
}
\description{
Gaussian process predictions using a heterogeneous noise GP object (of class \code{hetGP})
}
\details{
The full predictive variance corresponds to the sum of \code{sd2} and \code{nugs}.
See \code{\link[hetGP]{mleHetGP}} for examples.
}
