% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexDensity.R
\name{hexDensity}
\alias{hexDensity}
\title{Kernel Density Estimation with Hexagonal grid.}
\usage{
hexDensity(
  x,
  y = NULL,
  xbins = 128,
  bandwidth = NULL,
  edge = TRUE,
  diggle = FALSE,
  weight = NULL,
  ...
)
}
\arguments{
\item{x, y}{Coords of the points or a single plotting structure to be used in binning. See \link[grDevices]{xy.coords}.}

\item{xbins}{Number of bins in a row.}

\item{bandwidth}{Bandwidth for the smoothing kernel. Either a scalar, a vector of length 2, or a 2x2 variance-covariance matrix for the bandwidths in the x and y directions.}

\item{edge}{Logical value for whether to apply edge correction. Default is TRUE.}

\item{diggle}{Logical value for apply edge correction with the more accurate Jones-Diggle method (need 'edge' to be TRUE).}

\item{weight}{numeric weight vector to be assigned to points.}

\item{...}{arguments for \link[hexDensity]{hexbinFull}}
}
\value{
an S4 object of class \link[hexbin]{hexbin}.
}
\description{
Kernel Density Estimation with Hexagonal grid.
}
\details{
Default bandwidth is the normal scale bandwidth selector n^(-1/3)*var where n is sample size and var is the variance-covariance matrix.
}
\examples{
set.seed(133)
d = hexDensity(x=rnorm(200),y=rnorm(200))
}
\references{
Diggle, P. J. (2010) Nonparametric methods. Chapter 18, pp. 
299--316 in A.E. Gelfand, P.J. Diggle, M. Fuentes and P. Guttorp (eds.) 
Handbook of Spatial Statistics, CRC Press, Boca Raton, FL.

Jones, M. C. (1993) Simple boundary corrections for kernel 
density estimation. Statistics and Computing 3, 135--146.
}
