% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sticker.R
\name{sticker}
\alias{sticker}
\title{sticker}
\usage{
sticker(subplot, s_x = 0.8, s_y = 0.75, s_width = 0.4, s_height = 0.5,
  package, p_x = 1, p_y = 1.4, p_color = "#FFFFFF",
  p_family = "Aller_Rg", p_size = 8, h_size = 1.2, h_fill = "#1881C2",
  h_color = "#87B13F", filename = paste0(package, ".png"))
}
\arguments{
\item{subplot}{subplot}

\item{s_x}{x position for subplot}

\item{s_y}{y position for subplot}

\item{s_width}{width for subplot}

\item{s_height}{height for subplot}

\item{package}{package name}

\item{p_x}{x position for package name}

\item{p_y}{y position for package name}

\item{p_color}{color for package name}

\item{p_family}{font family for package name}

\item{p_size}{font size for package name}

\item{h_size}{size for hexagon border}

\item{h_fill}{color to fill hexagon}

\item{h_color}{color for hexagon boder}

\item{filename}{filename to save sticker}
}
\value{
gg object
}
\description{
create sticker in R
}
\examples{
library(ggplot2)
p <- ggplot(aes(x = mpg, y = wt), data = mtcars) + geom_point()
p <- p + theme_void() + theme_transparent()
sticker(p, package="hexSticker")
}
\author{
guangchuang yu
}

