% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.dummy.R
\name{make.dummy}
\alias{make.dummy}
\alias{make.dummy.extract}
\alias{make.dummy.extract.character}
\alias{make.dummy.extract.factor}
\alias{make.dummy.extract.logical}
\alias{make.dummy.extract.default}
\title{Make Dummy Variables}
\usage{
make.dummy(data)

make.dummy.extract(col, name)

\method{make.dummy.extract}{character}(col, name)

\method{make.dummy.extract}{factor}(col, name)

\method{make.dummy.extract}{logical}(col, name)

\method{make.dummy.extract}{default}(col, name)
}
\arguments{
\item{data}{The data frame from which dummy variables need to be extracted.}

\item{col}{A vector to extract dummy variables.}

\item{name}{The vector's name.}
}
\value{
The data frame with extracted dummy variables.
}
\description{
Function \code{make.dummy}
converts categorical variables in a data frame to dummy variables.

Function \code{make.dummy.extract}
converts a column to dummy variables if necessary
and assign appropriate names.
See the "detail" section for further information.
Users can define their own functions to allow the model
deal with some types of variables properly.
}
\details{
If \code{col} is a character vector,
the function will get unique values of its elements
and leave out the last one.
Then, all the unique values are combined with the \code{name} argument
as names of new columns.

If \code{col} is a factor vector,
the function will get its levels and leave out the last one.
Then, all level labels are combined with the \code{name} argument
as names of new columns.

If \code{col} is a logical vector,
the function will convert it to a numeric vector
with value \code{TRUE} mapped to \code{1} and \code{FALSE} to \code{0}.

If \code{col} is of other types,
the default behaviour for extracting dummy variables is
just to copy the original value and try to convert it to numeric values.
}
\examples{
make.dummy(iris["Species"])

make.dummy.extract(iris$Species, "Species")

make.dummy.extract(c("top", "mid", "low", "mid", "top"), "level")

make.dummy.extract(factor(c("far", "near", "near")), "distance")

make.dummy.extract(c(TRUE, TRUE, FALSE), "sold")

}
