% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmvnorm-mix-hhsmm.R
\name{rmixmvnorm}
\alias{rmixmvnorm}
\title{Random data generation from the mixture of multivariate normals for hhsmm model}
\usage{
rmixmvnorm(j, model)
}
\arguments{
\item{j}{a specified state}

\item{model}{a \code{\link{hhsmmspec}} model}
}
\value{
a random vector of observations from mixture of multivariate
normal distributions
}
\description{
Generates a vector of observations from mixture multivariate
normal distribution in a specified state and using the
parameters of a specified model
}
\examples{
J <- 3
initial <- c(1,0,0)
semi <- c(FALSE,TRUE,FALSE)
P <- matrix(c(0.8, 0.1, 0.1, 0.5, 0, 0.5, 0.1, 0.2, 0.7), nrow = J, byrow=TRUE)
par <- list(mu = list(list(7,8),list(10,9,11),list(12,14)),
sigma = list(list(3.8,4.9),list(4.3,4.2,5.4),list(4.5,6.1)),
mix.p = list(c(0.3,0.7),c(0.2,0.3,0.5),c(0.5,0.5)))
sojourn <- list(shape = c(0,3,0), scale = c(0,10,0), type = "gamma")
model <- hhsmmspec(init = initial, transition = P, parms.emis = par,
dens.emis = dmixmvnorm, sojourn = sojourn, semi = semi)
x = rmixmvnorm(1, model)

}
\author{
Morteza Amini, \email{morteza.amini@ut.ac.ir}, Afarin Bayat,  \email{aftbayat@gmail.com}
}
