% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ldm.r
\name{ldmat}
\alias{ldmat}
\title{LD variance-covariance matrix calculation}
\usage{
ldmat(
  geno,
  map = NULL,
  gwas.geno = NULL,
  gwas.map = NULL,
  chisq = NULL,
  ldchr = FALSE,
  threads = 4,
  verbose = TRUE
)
}
\arguments{
\item{geno}{the reference genotype panel in bigmemory format.}

\item{map}{the map information of reference genotype panel, columns are: SNPs, chromosome, physical position.}

\item{gwas.geno}{(optional) the genotype of gwas samples which were used to generate the summary data.}

\item{gwas.map}{(optional) the map information of the genotype of gwas samples, columns are: SNPs, chromosome, physical position.}

\item{chisq}{chi-squre value for generating sparse matrix, if n*r2 < chisq, it would be set to zero.}

\item{ldchr}{lpgical, whether to calulate the LD between chromosomes.}

\item{threads}{the number of threads used in computation.}

\item{verbose}{whether to print the information.}
}
\value{
For full ld matrix, it returns a standard R matrix, for sparse matrix, it returns a 'dgCMatrix'.
}
\description{
To calculate density or sparse LD variance-covariance matrix with genotype in bigmemory format.
}
\examples{
bfile_path = system.file("extdata", "geno", package = "hibayes")
data = read_plink(bfile_path, out=tempfile())
geno = data$geno
map = data$map
\donttest{
xx = ldmat(geno, threads=4)   #chromosome wide full ld matrix
xx = ldmat(geno, chisq=5, threads=4)   #chromosome wide sparse ld matrix
xx = ldmat(geno, map, ldchr=FALSE, threads=4)   #chromosome block ld matrix
xx = ldmat(geno, map, ldchr=FALSE, chisq=5, threads=4)   #chromosome block + sparse ld matrix
}

}
