% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hierarchicalSet.R
\name{HierarchicalSet-getters}
\alias{HierarchicalSet-getters}
\alias{cluster_members}
\alias{cluster_sizes}
\alias{clusters}
\alias{element_names}
\alias{n_clusters}
\alias{n_elements}
\alias{n_sets}
\alias{set_membership}
\alias{set_names}
\alias{sets}
\title{Getters for HierarchicalSet objects}
\usage{
sets(x)

clusters(x)

set_names(x)

element_names(x)

n_sets(x)

n_elements(x)

n_clusters(x)

cluster_sizes(x)

cluster_members(x)

set_membership(x)
}
\arguments{
\item{x}{A HierarchicalSet object}
}
\value{
depending on the function. See details
}
\description{
These utility functions makes it easy to extract raw information from a
HierarchicalSet object.
}
\details{
\code{sets} Returns a ngCMatrix with sets as columns and elements as rows.

\code{clusters} returns a list of dendrograms with the clustering in the
HierarchicalSet object

\code{set_names} returns a character vector with the names of the sets.

\code{element_names} returns a character vector with the names of the
elements

\code{n_sets} returns the number of sets

\code{n_elements} returns the number of elements

\code{n_clusters} returns the number of independent set families

\code{cluster_sizes} returns the number of sets in each independent set family

\code{cluster_members} returns the members of each independent set family

\code{set_membership} returns the cluster each set is member of
}
\examples{
data('twitter')

twitSet <- create_hierarchy(twitter)

# Get the sets as a presence/absence matrix
head(sets(twitSet))

# Get the clustering of the HierarchicalSet object
clusters(twitSet)

# Get the set names
set_names(twitSet)

# Get the element names or NULL if they are unnamed
element_names(twitSet)

# Get the number of sets
n_sets(twitSet)

# Get the number of elements
n_elements(twitSet)

# Get the number of independent clusters
n_clusters(twitSet)

# Get the size of each independent clusters
cluster_sizes(twitSet)

# Get the members of each independent clusters
cluster_members(twitSet)

# Get the membership of each set
set_membership(twitSet)

}

